/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.kernel.impl.newapi.ReadTestSupport;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

public class IndexProvidedValuesNativeBTree10Test
extends KernelAPIReadTestBase<ReadTestSupport> {
    private static int N_NODES = 10000;
    @Rule
    public RandomRule randomRule = new RandomRule();
    private List<Value> singlePropValues = new ArrayList<Value>();
    private List<ValueTuple> doublePropValues = new ArrayList<ValueTuple>();

    public ReadTestSupport newTestSupport() {
        ReadTestSupport readTestSupport = new ReadTestSupport();
        readTestSupport.addSetting(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName());
        return readTestSupport;
    }

    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            graphDb.schema().indexFor(Label.label((String)"Node")).on("prop").create();
            graphDb.schema().indexFor(Label.label((String)"Node")).on("prop").on("prip").create();
            tx.success();
        }
        tx = graphDb.beginTx();
        var3_3 = null;
        try {
            graphDb.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = graphDb.beginTx();
        var3_3 = null;
        try {
            RandomValues randomValues = this.randomRule.randomValues();
            ValueType[] allExceptNonSortable = RandomValues.excluding((ValueType[])new ValueType[]{ValueType.STRING, ValueType.STRING_ARRAY});
            for (int i = 0; i < N_NODES; ++i) {
                Node node = graphDb.createNode(new Label[]{Label.label((String)"Node")});
                Value propValue = randomValues.nextValueOfTypes(allExceptNonSortable);
                node.setProperty("prop", propValue.asObject());
                Value pripValue = randomValues.nextValueOfTypes(allExceptNonSortable);
                node.setProperty("prip", pripValue.asObject());
                this.singlePropValues.add(propValue);
                this.doublePropValues.add(ValueTuple.of((Value[])new Value[]{propValue, pripValue}));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.singlePropValues.sort((Comparator<Value>)Values.COMPARATOR);
        this.doublePropValues.sort(ValueTuple.COMPARATOR);
    }

    @Test
    public void shouldGetAllSinglePropertyValues() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        IndexReference index = this.schemaRead.index(label, new int[]{prop});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            this.read.nodeIndexScan(index, node, IndexOrder.NONE, true);
            ArrayList<Value> values = new ArrayList<Value>();
            while (node.next()) {
                values.add(node.propertyValue(0));
            }
            values.sort((Comparator<Value>)Values.COMPARATOR);
            for (int i = 0; i < this.singlePropValues.size(); ++i) {
                Assert.assertEquals((Object)this.singlePropValues.get(i), values.get(i));
            }
        }
    }

    @Test
    public void shouldGetAllDoublePropertyValues() throws Exception {
        int label = this.token.nodeLabel("Node");
        int prop = this.token.propertyKey("prop");
        int prip = this.token.propertyKey("prip");
        IndexReference index = this.schemaRead.index(label, new int[]{prop, prip});
        try (NodeValueIndexCursor node = this.cursors.allocateNodeValueIndexCursor();){
            this.read.nodeIndexScan(index, node, IndexOrder.NONE, true);
            ArrayList<ValueTuple> values = new ArrayList<ValueTuple>();
            while (node.next()) {
                values.add(ValueTuple.of((Value[])new Value[]{node.propertyValue(0), node.propertyValue(1)}));
            }
            values.sort(ValueTuple.COMPARATOR);
            for (int i = 0; i < this.doublePropValues.size(); ++i) {
                Assert.assertEquals((Object)this.doublePropValues.get(i), values.get(i));
            }
        }
    }
}

