/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.File;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.TestGraphDatabaseFactory;

class WriteTestSupport
implements KernelAPIWriteTestSupport {
    private GraphDatabaseService db;

    WriteTestSupport() {
    }

    public void setup(File storeDir) {
        this.db = this.newDb(storeDir);
    }

    protected GraphDatabaseService newDb(File storeDir) {
        return new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder(storeDir).newGraphDatabase();
    }

    public void clearGraph() {
        GraphDatabaseServiceCleaner.cleanDatabaseContent((GraphDatabaseService)this.db);
        try (Transaction tx = this.db.beginTx();){
            PropertyContainer graphProperties = this.graphProperties();
            for (String key : graphProperties.getPropertyKeys()) {
                graphProperties.removeProperty(key);
            }
            tx.success();
        }
    }

    public PropertyContainer graphProperties() {
        return ((EmbeddedProxySPI)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(EmbeddedProxySPI.class)).newGraphPropertiesProxy();
    }

    public Kernel kernelToTest() {
        DependencyResolver resolver = ((GraphDatabaseAPI)this.db).getDependencyResolver();
        return (Kernel)resolver.resolveDependency(Kernel.class);
    }

    public GraphDatabaseService graphBackdoor() {
        return this.db;
    }

    public void tearDown() {
        this.db.shutdown();
        this.db = null;
    }
}

