/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.LogMatchers;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class KernelRecoveryTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void shouldHandleWritesProperlyAfterRecovery() throws Exception {
        EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.fsRule.get();
        GraphDatabaseService db = this.newDB((FileSystemAbstraction)fs);
        long node1 = KernelRecoveryTest.createNode(db);
        try (EphemeralFileSystemAbstraction crashedFs = fs.snapshot();){
            db.shutdown();
            db = this.newDB((FileSystemAbstraction)crashedFs);
            long node2 = KernelRecoveryTest.createNode(db);
            db.shutdown();
            File logFile = this.testDirectory.databaseLayout().file("neostore.transaction.db.0");
            MatcherAssert.assertThat((Object)LogMatchers.logEntries((FileSystemAbstraction)crashedFs, (File)logFile), (Matcher)LogMatchers.containsExactly((Matcher[])new Matcher[]{LogMatchers.startEntry((int)-1, (int)-1), LogMatchers.commandEntry((long)node1, Command.NodeCommand.class), LogMatchers.commandEntry((long)-1L, Command.NodeCountsCommand.class), LogMatchers.commitEntry((long)2L), LogMatchers.startEntry((int)-1, (int)-1), LogMatchers.commandEntry((long)node2, Command.NodeCommand.class), LogMatchers.commandEntry((long)-1L, Command.NodeCountsCommand.class), LogMatchers.commitEntry((long)3L), LogMatchers.checkPoint((LogPosition)new LogPosition(0L, 250L))}));
        }
    }

    private GraphDatabaseService newDB(FileSystemAbstraction fs) {
        return new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(fs)).newImpermanentDatabase(this.testDirectory.databaseDir());
    }

    private static long createNode(GraphDatabaseService db) {
        long node1;
        try (Transaction tx = db.beginTx();){
            node1 = db.createNode().getId();
            tx.success();
        }
        return node1;
    }
}

