/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReaderTestBase;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;

public class RecordStorageReaderNodeAndRelTest
extends RecordStorageReaderTestBase {
    @Test
    public void shouldTellIfNodeExists() {
        long created = RecordStorageReaderNodeAndRelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[0]), new Label[0]).getId();
        long createdAndRemoved = RecordStorageReaderNodeAndRelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[0]), new Label[0]).getId();
        long neverExisted = createdAndRemoved + 99L;
        try (Transaction tx = this.db.beginTx();){
            this.db.getNodeById(createdAndRemoved).delete();
            tx.success();
        }
        Assert.assertTrue((boolean)this.nodeExists(created));
        Assert.assertFalse((boolean)this.nodeExists(createdAndRemoved));
        Assert.assertFalse((boolean)this.nodeExists(neverExisted));
    }

    @Test
    public void shouldTellIfRelExists() {
        long createdAndRemoved;
        long created;
        long node = RecordStorageReaderNodeAndRelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[0]), new Label[0]).getId();
        try (Transaction tx = this.db.beginTx();){
            created = this.db.createNode().createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"Banana")).getId();
            createdAndRemoved = this.db.createNode().createRelationshipTo(this.db.createNode(), RelationshipType.withName((String)"Banana")).getId();
            tx.success();
        }
        tx = this.db.beginTx();
        var10_3 = null;
        try {
            this.db.getRelationshipById(createdAndRemoved).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var10_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var10_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var10_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long neverExisted = created + 99L;
        Assert.assertTrue((boolean)this.relationshipExists(node));
        Assert.assertFalse((boolean)this.relationshipExists(createdAndRemoved));
        Assert.assertFalse((boolean)this.relationshipExists(neverExisted));
    }

    private boolean nodeExists(long id) {
        try (StorageNodeCursor node = this.storageReader.allocateNodeCursor();){
            node.single(id);
            boolean bl = node.next();
            return bl;
        }
    }

    private boolean relationshipExists(long id) {
        try (StorageRelationshipScanCursor relationship = this.storageReader.allocateRelationshipScanCursor();){
            relationship.single(id);
            boolean bl = relationship.next();
            return bl;
        }
    }
}

