/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;

public class IdGeneratorRebuildFailureEmulationTest {
    private FileSystem fs;
    private StoreFactory factory;
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private DatabaseLayout databaseLayout;

    @Before
    public void initialize() {
        this.fs = new FileSystem();
        this.databaseLayout = this.testDirectory.databaseLayout();
        Database graphdb = new Database(this.databaseLayout.databaseDirectory());
        this.createInitialData((GraphDatabaseService)graphdb);
        graphdb.shutdown();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GraphDatabaseSettings.rebuild_idgenerators_fast.name(), "false");
        Config config = Config.defaults(params);
        this.factory = new StoreFactory(this.databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs), (FileSystemAbstraction)this.fs, (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
    }

    @After
    public void verifyAndDispose() throws Exception {
        Database graphdb = null;
        try {
            graphdb = new Database(this.databaseLayout.databaseDirectory());
            this.verifyData((GraphDatabaseService)graphdb);
        }
        finally {
            if (graphdb != null) {
                graphdb.shutdown();
            }
            if (this.fs != null) {
                this.fs.disposeAndAssertNoOpenFiles();
            }
            this.fs = null;
        }
    }

    private void performTest(File idFile) {
        this.fs.deleteFile(idFile);
        try {
            NeoStores neoStores = this.factory.openAllNeoStores();
            Throwable throwable = null;
            if (neoStores != null) {
                if (throwable != null) {
                    try {
                        neoStores.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    neoStores.close();
                }
            }
        }
        catch (UnderlyingStorageException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)Matchers.startsWith((String)"Id capacity exceeded"));
        }
    }

    private void verifyData(GraphDatabaseService graphdb) {
        try (Transaction tx = graphdb.beginTx();){
            int nodecount = 0;
            for (Node node : graphdb.getAllNodes()) {
                int propcount = this.readProperties((PropertyContainer)node);
                int relcount = 0;
                for (Relationship rel : node.getRelationships()) {
                    Assert.assertEquals((String)"all relationships should have 3 properties.", (long)3L, (long)this.readProperties((PropertyContainer)rel));
                    ++relcount;
                }
                Assert.assertEquals((String)"all created nodes should have 3 properties.", (long)3L, (long)propcount);
                Assert.assertEquals((String)"all created nodes should have 2 relationships.", (long)2L, (long)relcount);
                ++nodecount;
            }
            Assert.assertEquals((String)"The database should have 2 nodes.", (long)2L, (long)nodecount);
        }
    }

    private void createInitialData(GraphDatabaseService graphdb) {
        try (Transaction tx = graphdb.beginTx();){
            Node first = this.properties(graphdb.createNode());
            Node other = this.properties(graphdb.createNode());
            this.properties(first.createRelationshipTo(other, RelationshipType.withName((String)"KNOWS")));
            this.properties(other.createRelationshipTo(first, RelationshipType.withName((String)"DISTRUSTS")));
            tx.success();
        }
    }

    private <E extends PropertyContainer> E properties(E entity) {
        entity.setProperty("short thing", (Object)"short");
        entity.setProperty("long thing", (Object)"this is quite a long string, don't you think, it sure is long enough at least");
        entity.setProperty("string array", (Object)new String[]{"these are a few", "cool strings", "for your viewing pleasure"});
        return entity;
    }

    private int readProperties(PropertyContainer entity) {
        int count = 0;
        for (String key : entity.getPropertyKeys()) {
            entity.getProperty(key);
            ++count;
        }
        return count;
    }

    @Test
    public void neostore() {
        this.performTest(this.databaseLayout.idMetadataStore());
    }

    @Test
    public void neostore_nodestore_db() {
        this.performTest(this.databaseLayout.idNodeStore());
    }

    @Test
    public void neostore_propertystore_db_arrays() {
        this.performTest(this.databaseLayout.idPropertyArrayStore());
    }

    @Test
    public void neostore_propertystore_db() {
        this.performTest(this.databaseLayout.idPropertyStore());
    }

    @Test
    public void neostore_propertystore_db_index() {
        this.performTest(this.databaseLayout.idPropertyKeyTokenStore());
    }

    @Test
    public void neostore_propertystore_db_index_keys() {
        this.performTest(this.databaseLayout.idPropertyKeyTokenNamesStore());
    }

    @Test
    public void neostore_propertystore_db_strings() {
        this.performTest(this.databaseLayout.idPropertyStringStore());
    }

    @Test
    public void neostore_relationshipstore_db() {
        this.performTest(this.databaseLayout.idRelationshipStore());
    }

    @Test
    public void neostore_relationshiptypestore_db() {
        this.performTest(this.databaseLayout.idRelationshipTypeTokenStore());
    }

    @Test
    public void neostore_relationshiptypestore_db_names() {
        this.performTest(this.databaseLayout.idRelationshipTypeTokenNamesStore());
    }

    private class Database
    extends ImpermanentGraphDatabase {
        Database(File storeDir) {
            super(storeDir);
        }

        protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            File absoluteStoreDir = storeDir.getAbsoluteFile();
            File databasesRoot = absoluteStoreDir.getParentFile();
            params.put(GraphDatabaseSettings.active_database.name(), absoluteStoreDir.getName());
            params.put(GraphDatabaseSettings.databases_root_path.name(), databasesRoot.getAbsolutePath());
            new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

                protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                    return new ImpermanentGraphDatabase.ImpermanentPlatformModule(storeDir, config, this.databaseInfo, dependencies){

                        protected FileSystemAbstraction createFileSystemAbstraction() {
                            return IdGeneratorRebuildFailureEmulationTest.this.fs;
                        }
                    };
                }
            }.initFacade(databasesRoot, params, dependencies, (GraphDatabaseFacade)this);
        }
    }

    private static class FileSystem
    extends EphemeralFileSystemAbstraction {
        private FileSystem() {
        }

        void disposeAndAssertNoOpenFiles() throws Exception {
            this.assertNoOpenFiles();
            super.close();
        }

        public void close() {
        }
    }
}

