/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class TestGraphProperties {
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private TestGraphDatabaseFactory factory;

    @Before
    public void before() {
        this.factory = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fs.get()));
    }

    @Test
    public void basicProperties() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        PropertyContainer graphProperties = TestGraphProperties.properties(db);
        Assert.assertThat((Object)graphProperties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)"test"))));
        Transaction tx = db.beginTx();
        graphProperties.setProperty("test", (Object)"yo");
        Assert.assertEquals((Object)"yo", (Object)graphProperties.getProperty("test"));
        tx.success();
        tx.close();
        Assert.assertThat((Object)graphProperties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"test").withValue((Object)"yo")));
        tx = db.beginTx();
        Assert.assertNull((Object)graphProperties.removeProperty("something non existent"));
        Assert.assertEquals((Object)"yo", (Object)graphProperties.removeProperty("test"));
        Assert.assertNull((Object)graphProperties.getProperty("test", null));
        graphProperties.setProperty("other", (Object)10);
        Assert.assertEquals((Object)10, (Object)graphProperties.getProperty("other"));
        graphProperties.setProperty("new", (Object)"third");
        tx.success();
        tx.close();
        Assert.assertThat((Object)graphProperties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)"test"))));
        Assert.assertThat((Object)graphProperties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"other").withValue((Object)10)));
        Assert.assertThat((Object)Neo4jMatchers.getPropertyKeys((GraphDatabaseService)db, (PropertyContainer)graphProperties), (Matcher)Neo4jMatchers.containsOnly((Object[])new String[]{"other", "new"}));
        tx = db.beginTx();
        graphProperties.setProperty("rollback", (Object)true);
        Assert.assertEquals((Object)true, (Object)graphProperties.getProperty("rollback"));
        tx.close();
        Assert.assertThat((Object)graphProperties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)"rollback"))));
        db.shutdown();
    }

    @Test
    public void getNonExistentGraphPropertyWithDefaultValue() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        PropertyContainer graphProperties = TestGraphProperties.properties(db);
        Transaction tx = db.beginTx();
        Assert.assertEquals((Object)"default", (Object)graphProperties.getProperty("test", (Object)"default"));
        tx.success();
        tx.close();
        db.shutdown();
    }

    @Test
    public void setManyGraphProperties() {
        int i;
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        Transaction tx = db.beginTx();
        Object[] values = new Object[]{10, "A string value", new float[]{1234.567f, 7654.321f}, "A rather longer string which wouldn't fit inlined #!)(&\u00a4"};
        int count = 200;
        for (i = 0; i < count; ++i) {
            TestGraphProperties.properties(db).setProperty("key" + i, values[i % values.length]);
        }
        tx.success();
        tx.close();
        for (i = 0; i < count; ++i) {
            Assert.assertThat((Object)TestGraphProperties.properties(db), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)("key" + i)).withValue(values[i % values.length])));
        }
        for (i = 0; i < count; ++i) {
            Assert.assertThat((Object)TestGraphProperties.properties(db), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)("key" + i)).withValue(values[i % values.length])));
        }
        db.shutdown();
    }

    @Test
    public void setBigArrayGraphProperty() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        long[] array = new long[1000];
        for (int i = 0; i < 10; ++i) {
            array[array.length / 10 * i] = i;
        }
        String key = "big long array";
        Transaction tx = db.beginTx();
        TestGraphProperties.properties(db).setProperty(key, (Object)array);
        Assert.assertThat((Object)TestGraphProperties.properties(db), (Matcher)Neo4jMatchers.hasProperty((String)key).withValue((Object)array));
        tx.success();
        tx.close();
        Assert.assertThat((Object)TestGraphProperties.properties(db), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)key).withValue((Object)array)));
        Assert.assertThat((Object)TestGraphProperties.properties(db), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)key).withValue((Object)array)));
        db.shutdown();
    }

    private static PropertyContainer properties(GraphDatabaseAPI db) {
        return ((EmbeddedProxySPI)db.getDependencyResolver().resolveDependency(EmbeddedProxySPI.class)).newGraphPropertiesProxy();
    }

    @Test
    public void firstRecordOtherThanZeroIfNotFirst() {
        File storeDir = this.testDirectory.databaseDir();
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase(storeDir);
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Yo");
        tx.success();
        tx.close();
        db.shutdown();
        db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase(storeDir);
        tx = db.beginTx();
        TestGraphProperties.properties(db).setProperty("test", (Object)"something");
        tx.success();
        tx.close();
        db.shutdown();
        Config config = Config.defaults();
        StoreFactory storeFactory = new StoreFactory(this.testDirectory.databaseLayout(), config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs.get()), pageCacheRule.getPageCache(this.fs.get()), this.fs.get(), (LogProvider)NullLogProvider.getInstance(), EmptyVersionContextSupplier.EMPTY);
        NeoStores neoStores = storeFactory.openAllNeoStores();
        long prop = neoStores.getMetaDataStore().getGraphNextProp();
        Assert.assertTrue((prop != 0L ? 1 : 0) != 0);
        neoStores.close();
    }

    @Test
    public void graphPropertiesAreLockedPerTx() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        Worker worker1 = new Worker("W1", new State(db));
        Worker worker2 = new Worker("W2", new State(db));
        PropertyContainer properties = TestGraphProperties.properties(db);
        worker1.beginTx();
        worker2.beginTx();
        String key1 = "name";
        String value1 = "Value 1";
        String key2 = "some other property";
        String value2 = "Value 2";
        String key3 = "say";
        String value3 = "hello";
        worker1.setProperty(key1, value1).get();
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)key1))));
        Assert.assertFalse((boolean)worker2.hasProperty(key1));
        Future<Void> blockedSetProperty = worker2.setProperty(key2, value2);
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)key1))));
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)key2))));
        worker1.setProperty(key3, value3).get();
        Assert.assertFalse((boolean)blockedSetProperty.isDone());
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)key1))));
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)key2))));
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)key3))));
        worker1.commitTx();
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)key1)));
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Matchers.not((Matcher)Neo4jMatchers.hasProperty((String)key2))));
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)key3)));
        blockedSetProperty.get();
        Assert.assertTrue((boolean)blockedSetProperty.isDone());
        worker2.commitTx();
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)key1).withValue((Object)value1)));
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)key2).withValue((Object)value2)));
        Assert.assertThat((Object)properties, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)key3).withValue((Object)value3)));
        worker1.close();
        worker2.close();
        db.shutdown();
    }

    @Test
    public void twoUncleanInARow() throws Exception {
        File databaseDir = this.testDirectory.databaseDir();
        try (EphemeralFileSystemAbstraction snapshot = this.produceUncleanStore((EphemeralFileSystemAbstraction)this.fs.get(), databaseDir);
             EphemeralFileSystemAbstraction snapshot2 = this.produceUncleanStore(snapshot, databaseDir);){
            GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.produceUncleanStore(snapshot2, databaseDir)).newImpermanentDatabase(databaseDir);
            Assert.assertThat((Object)TestGraphProperties.properties(db), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"prop").withValue((Object)"Some value")));
            db.shutdown();
        }
    }

    @Test
    public void testEquals() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        PropertyContainer graphProperties = TestGraphProperties.properties(db);
        try (Transaction tx = db.beginTx();){
            graphProperties.setProperty("test", (Object)"test");
            tx.success();
        }
        Assert.assertEquals((Object)graphProperties, (Object)TestGraphProperties.properties(db));
        db.shutdown();
        db = (GraphDatabaseAPI)this.factory.newImpermanentDatabase();
        Assert.assertNotEquals((Object)graphProperties, (Object)TestGraphProperties.properties(db));
        db.shutdown();
    }

    @Test
    public void shouldBeAbleToCreateLongGraphPropertyChainsAndReadTheCorrectNextPointerFromTheStore() {
        GraphDatabaseService database = this.factory.newImpermanentDatabase();
        PropertyContainer graphProperties = TestGraphProperties.properties((GraphDatabaseAPI)database);
        try (Transaction tx = database.beginTx();){
            graphProperties.setProperty("a", (Object)new String[]{"A", "B", "C", "D", "E"});
            graphProperties.setProperty("b", (Object)true);
            graphProperties.setProperty("c", (Object)"C");
            tx.success();
        }
        tx = database.beginTx();
        var4_4 = null;
        try {
            graphProperties.setProperty("d", (Object)new String[]{"A", "F"});
            graphProperties.setProperty("e", (Object)true);
            graphProperties.setProperty("f", (Object)"F");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = database.beginTx();
        var4_4 = null;
        try {
            graphProperties.setProperty("g", (Object)new String[]{"F"});
            graphProperties.setProperty("h", (Object)false);
            graphProperties.setProperty("i", (Object)"I");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = database.beginTx();
        var4_4 = null;
        try {
            Assert.assertArrayEquals((Object[])new String[]{"A", "B", "C", "D", "E"}, (Object[])((String[])graphProperties.getProperty("a")));
            Assert.assertTrue((boolean)((Boolean)graphProperties.getProperty("b")));
            Assert.assertEquals((Object)"C", (Object)graphProperties.getProperty("c"));
            Assert.assertArrayEquals((Object[])new String[]{"A", "F"}, (Object[])((String[])graphProperties.getProperty("d")));
            Assert.assertTrue((boolean)((Boolean)graphProperties.getProperty("e")));
            Assert.assertEquals((Object)"F", (Object)graphProperties.getProperty("f"));
            Assert.assertArrayEquals((Object[])new String[]{"F"}, (Object[])((String[])graphProperties.getProperty("g")));
            Assert.assertFalse((boolean)((Boolean)graphProperties.getProperty("h")));
            Assert.assertEquals((Object)"I", (Object)graphProperties.getProperty("i"));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        database.shutdown();
    }

    private EphemeralFileSystemAbstraction produceUncleanStore(EphemeralFileSystemAbstraction fileSystem, File storeDir) {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fileSystem).newImpermanentDatabase(storeDir);
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Something");
        TestGraphProperties.properties((GraphDatabaseAPI)db).setProperty("prop", (Object)"Some value");
        tx.success();
        tx.close();
        EphemeralFileSystemAbstraction snapshot = fileSystem.snapshot();
        db.shutdown();
        return snapshot;
    }

    private static class Worker
    extends OtherThreadExecutor<State> {
        Worker(String name, State initialState) {
            super(name, (Object)initialState);
        }

        public boolean hasProperty(String key) throws Exception {
            return (Boolean)this.execute(state -> ((State)state).properties.hasProperty(key));
        }

        public void commitTx() throws Exception {
            this.execute(state -> {
                ((State)state).tx.success();
                ((State)state).tx.close();
                return null;
            });
        }

        void beginTx() throws Exception {
            this.execute(state -> {
                ((State)state).tx = ((State)state).db.beginTx();
                return null;
            });
        }

        Future<Void> setProperty(String key, Object value) {
            return this.executeDontWait(state -> {
                ((State)state).properties.setProperty(key, value);
                return null;
            });
        }
    }

    private static class State {
        private final GraphDatabaseAPI db;
        private final PropertyContainer properties;
        private Transaction tx;

        State(GraphDatabaseAPI db) {
            this.db = db;
            this.properties = TestGraphProperties.properties(db);
        }
    }
}

