/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.impl.util.monitoring.SilentProgressReporter;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class CountsComputerTest {
    private static final NullLogProvider LOG_PROVIDER = NullLogProvider.getInstance();
    private static final Config CONFIG = Config.defaults();
    private final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final PageCacheRule pcRule = new PageCacheRule();
    private final TestDirectory testDir = TestDirectory.testDirectory((FileSystemAbstraction)this.fsRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.pcRule).around((TestRule)this.fsRule).around((TestRule)this.testDir);
    private FileSystemAbstraction fs;
    private GraphDatabaseBuilder dbBuilder;
    private PageCache pageCache;

    @Before
    public void setup() {
        this.fs = this.fsRule.get();
        this.dbBuilder = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fs)).newImpermanentDatabaseBuilder(this.testDir.databaseDir());
        this.pageCache = this.pcRule.getPageCache(this.fs);
    }

    @Test
    public void skipPopulationWhenNodeAndRelationshipStoresAreEmpty() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        InvocationTrackingProgressReporter progressReporter = new InvocationTrackingProgressReporter();
        this.rebuildCounts(lastCommittedTransactionId, progressReporter);
        this.checkEmptyCountStore();
        Assert.assertTrue((boolean)progressReporter.isCompleteInvoked());
        Assert.assertFalse((boolean)progressReporter.isStartInvoked());
    }

    @Test
    public void shouldCreateAnEmptyCountsStoreFromAnEmptyDatabase() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        this.checkEmptyCountStore();
    }

    @Test
    public void shouldCreateACountsStoreWhenThereAreNodesInTheDB() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{Label.label((String)"A")});
            db.createNode(new Label[]{Label.label((String)"C")});
            db.createNode(new Label[]{Label.label((String)"D")});
            db.createNode();
            tx.success();
        }
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker());
            Assert.assertEquals((long)5L, (long)store.txId());
            Assert.assertEquals((long)4L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)4L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)0L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)2L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)3L)));
        }
    }

    @Test
    public void shouldCreateACountsStoreWhenThereAreUnusedNodeRecordsInTheDB() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{Label.label((String)"A")});
            db.createNode(new Label[]{Label.label((String)"C")});
            Node node = db.createNode(new Label[]{Label.label((String)"D")});
            db.createNode();
            node.delete();
            tx.success();
        }
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker());
            Assert.assertEquals((long)5L, (long)store.txId());
            Assert.assertEquals((long)3L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)3L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)0L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)1L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)2L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)3L)));
        }
    }

    @Test
    public void shouldCreateACountsStoreWhenThereAreUnusedRelationshipRecordsInTheDB() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            Node nodeA = db.createNode(new Label[]{Label.label((String)"A")});
            Node nodeC = db.createNode(new Label[]{Label.label((String)"C")});
            Relationship rel = nodeA.createRelationshipTo(nodeC, RelationshipType.withName((String)"TYPE1"));
            nodeC.createRelationshipTo(nodeA, RelationshipType.withName((String)"TYPE2"));
            rel.delete();
            tx.success();
        }
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker());
            Assert.assertEquals((long)6L, (long)store.txId());
            Assert.assertEquals((long)9L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)2L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)0L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)1L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)2L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)3L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)0, (long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)1, (long)-1L)));
        }
    }

    @Test
    public void shouldCreateACountsStoreWhenThereAreNodesAndRelationshipsInTheDB() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            Node nodeA = db.createNode(new Label[]{Label.label((String)"A")});
            Node nodeC = db.createNode(new Label[]{Label.label((String)"C")});
            Node nodeD = db.createNode(new Label[]{Label.label((String)"D")});
            Node node = db.createNode();
            nodeA.createRelationshipTo(nodeD, RelationshipType.withName((String)"TYPE"));
            node.createRelationshipTo(nodeC, RelationshipType.withName((String)"TYPE2"));
            tx.success();
        }
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker());
            Assert.assertEquals((long)7L, (long)store.txId());
            Assert.assertEquals((long)13L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)4L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)0L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)2L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)3L)));
            Assert.assertEquals((long)2L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)-1, (long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)0, (long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)1, (long)-1L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)2, (long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)1, (long)1L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)0, (long)1L)));
        }
    }

    @Test
    public void shouldCreateACountStoreWhenDBContainsDenseNodes() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.setConfig(GraphDatabaseSettings.dense_node_threshold, "2").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            Node nodeA = db.createNode(new Label[]{Label.label((String)"A")});
            Node nodeC = db.createNode(new Label[]{Label.label((String)"C")});
            Node nodeD = db.createNode(new Label[]{Label.label((String)"D")});
            nodeA.createRelationshipTo(nodeA, RelationshipType.withName((String)"TYPE1"));
            nodeA.createRelationshipTo(nodeC, RelationshipType.withName((String)"TYPE2"));
            nodeA.createRelationshipTo(nodeD, RelationshipType.withName((String)"TYPE3"));
            nodeD.createRelationshipTo(nodeC, RelationshipType.withName((String)"TYPE4"));
            tx.success();
        }
        long lastCommittedTransactionId = this.getLastTxId(db);
        db.shutdown();
        this.rebuildCounts(lastCommittedTransactionId);
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker());
            Assert.assertEquals((long)9L, (long)store.txId());
            Assert.assertEquals((long)22L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)3L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)0L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)2L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.nodeKey((long)3L)));
            Assert.assertEquals((long)4L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)-1, (long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)0, (long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)1, (long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)2, (long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)3, (long)-1L)));
            Assert.assertEquals((long)0L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)4, (long)-1L)));
            Assert.assertEquals((long)1L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)1, (long)1L)));
            Assert.assertEquals((long)2L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)-1L, (int)-1, (long)1L)));
            Assert.assertEquals((long)3L, (long)this.get(store, (CountsKey)CountsKeyFactory.relationshipKey((long)0L, (int)-1, (long)-1L)));
        }
    }

    private File alphaStoreFile() {
        return this.testDir.databaseLayout().countStoreA();
    }

    private File betaStoreFile() {
        return this.testDir.databaseLayout().countStoreB();
    }

    private long getLastTxId(GraphDatabaseAPI db) {
        return ((TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastCommittedTransactionId();
    }

    private void checkEmptyCountStore() {
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker());
            Assert.assertEquals((long)1L, (long)store.txId());
            Assert.assertEquals((long)0L, (long)store.totalEntriesStored());
        }
    }

    private void cleanupCountsForRebuilding() {
        this.fs.deleteFile(this.alphaStoreFile());
        this.fs.deleteFile(this.betaStoreFile());
    }

    private CountsTracker createCountsTracker() {
        return new CountsTracker((LogProvider)LOG_PROVIDER, this.fs, this.pageCache, CONFIG, this.testDir.databaseLayout(), EmptyVersionContextSupplier.EMPTY);
    }

    private void rebuildCounts(long lastCommittedTransactionId) {
        this.rebuildCounts(lastCommittedTransactionId, (ProgressReporter)SilentProgressReporter.INSTANCE);
    }

    private void rebuildCounts(long lastCommittedTransactionId, ProgressReporter progressReporter) {
        this.cleanupCountsForRebuilding();
        DefaultIdGeneratorFactory idGenFactory = new DefaultIdGeneratorFactory(this.fs);
        StoreFactory storeFactory = new StoreFactory(this.testDir.databaseLayout(), CONFIG, (IdGeneratorFactory)idGenFactory, this.pageCache, this.fs, (LogProvider)LOG_PROVIDER, EmptyVersionContextSupplier.EMPTY);
        try (Lifespan life = new Lifespan(new Lifecycle[0]);
             NeoStores neoStores = storeFactory.openAllNeoStores();){
            NodeStore nodeStore = neoStores.getNodeStore();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            int highLabelId = (int)neoStores.getLabelTokenStore().getHighId();
            int highRelationshipTypeId = (int)neoStores.getRelationshipTypeTokenStore().getHighId();
            CountsComputer countsComputer = new CountsComputer(lastCommittedTransactionId, nodeStore, relationshipStore, highLabelId, highRelationshipTypeId, NumberArrayFactory.AUTO_WITHOUT_PAGECACHE, progressReporter);
            CountsTracker countsTracker = this.createCountsTracker();
            life.add((Lifecycle)countsTracker.setInitializer((DataInitializer)countsComputer));
        }
    }

    private long get(CountsTracker store, CountsKey key) {
        Register.DoubleLongRegister value = Registers.newDoubleLongRegister();
        store.get(key, value);
        return value.readSecond();
    }

    private static class InvocationTrackingProgressReporter
    implements ProgressReporter {
        private boolean startInvoked;
        private boolean completeInvoked;

        private InvocationTrackingProgressReporter() {
        }

        public void start(long max) {
            this.startInvoked = true;
        }

        public void progress(long add) {
        }

        public void completed() {
            this.completeInvoked = true;
        }

        boolean isStartInvoked() {
            return this.startInvoked;
        }

        boolean isCompleteInvoked() {
            return this.completeInvoked;
        }
    }
}

