/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class ReuseExcessBatchIdsOnRestartIT {
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule();

    @Test
    public void shouldReuseExcessBatchIdsWhichWerentUsedBeforeClose() throws Exception {
        Node secondNode;
        Node firstNode;
        try (Transaction tx = this.db.beginTx();){
            firstNode = this.db.createNode();
            tx.success();
        }
        this.db.restartDatabase(new String[0]);
        try (Transaction tx = this.db.beginTx();){
            secondNode = this.db.createNode();
            tx.success();
        }
        Assert.assertEquals((long)(firstNode.getId() + 1L), (long)secondNode.getId());
    }
}

