/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.LogTestUtils;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class ReadTransactionLogWritingTest {
    @Rule
    public final DatabaseRule dbr = new ImpermanentDatabaseRule();
    private final Label label = Label.label((String)"Test");
    private Node node;
    private Relationship relationship;
    private long logEntriesWrittenBeforeReadOperations;

    @Before
    public void createDataset() {
        GraphDatabaseAPI db = this.dbr.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            this.node = db.createNode(new Label[]{this.label});
            this.node.setProperty("short", (Object)123);
            this.node.setProperty("long", (Object)this.longString(300));
            this.relationship = this.node.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            this.relationship.setProperty("short", (Object)123);
            this.relationship.setProperty("long", (Object)this.longString(300));
            tx.success();
        }
        this.logEntriesWrittenBeforeReadOperations = this.countLogEntries();
    }

    @Test
    public void shouldNotWriteAnyLogCommandInPureReadTransaction() {
        this.executeTransaction(this.getRelationships());
        this.executeTransaction(this.getProperties());
        this.executeTransaction(this.getById());
        this.executeTransaction(this.getNodesFromRelationship());
        long actualCount = this.countLogEntries();
        Assert.assertEquals((String)("There were " + (actualCount - this.logEntriesWrittenBeforeReadOperations) + " log entries written during one or more pure read transactions"), (long)this.logEntriesWrittenBeforeReadOperations, (long)actualCount);
    }

    private long countLogEntries() {
        GraphDatabaseAPI db = this.dbr.getGraphDatabaseAPI();
        FileSystemAbstraction fs = (FileSystemAbstraction)db.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
        LogFiles logFiles = (LogFiles)db.getDependencyResolver().resolveDependency(LogFiles.class);
        try {
            LogTestUtils.CountingLogHook logicalLogCounter = new LogTestUtils.CountingLogHook();
            LogTestUtils.filterNeostoreLogicalLog((LogFiles)logFiles, (FileSystemAbstraction)fs, (LogTestUtils.LogHook)logicalLogCounter);
            long txLogRecordCount = logFiles.getLogFileInformation().getLastEntryId();
            return (long)logicalLogCounter.getCount() + txLogRecordCount;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String longString(int length) {
        char[] characters = new char[length];
        for (int i = 0; i < length; ++i) {
            characters[i] = (char)(97 + i % 10);
        }
        return new String(characters);
    }

    private void executeTransaction(Runnable runnable) {
        this.executeTransaction(runnable, true);
        this.executeTransaction(runnable, false);
    }

    private void executeTransaction(Runnable runnable, boolean success) {
        try (Transaction tx = this.dbr.getGraphDatabaseAPI().beginTx();){
            runnable.run();
            if (success) {
                tx.success();
            }
        }
    }

    private Runnable getRelationships() {
        return () -> Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)this.node.getRelationships()));
    }

    private Runnable getNodesFromRelationship() {
        return () -> {
            this.relationship.getEndNode();
            this.relationship.getStartNode();
            this.relationship.getNodes();
            this.relationship.getOtherNode(this.node);
        };
    }

    private Runnable getById() {
        return () -> {
            this.dbr.getGraphDatabaseAPI().getNodeById(this.node.getId());
            this.dbr.getGraphDatabaseAPI().getRelationshipById(this.relationship.getId());
        };
    }

    private Runnable getProperties() {
        return new Runnable(){

            @Override
            public void run() {
                this.getAllProperties((PropertyContainer)ReadTransactionLogWritingTest.this.node);
                this.getAllProperties((PropertyContainer)ReadTransactionLogWritingTest.this.relationship);
            }

            private void getAllProperties(PropertyContainer entity) {
                for (String key : entity.getPropertyKeys()) {
                    entity.getProperty(key);
                }
            }
        };
    }
}

