/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.transaction.TransactionCountersChecker;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

@RunWith(value=Parameterized.class)
public class TransactionMonitorTest {
    @Parameterized.Parameter(value=0)
    public ThrowingConsumer<GraphDatabaseService, Exception> dbConsumer;
    @Parameterized.Parameter(value=1)
    public boolean isWriteTx;
    @Parameterized.Parameter(value=2)
    public String ignored;

    @Parameterized.Parameters(name="{2}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({db -> {}, false, "read"}, {GraphDatabaseService::createNode, true, "write"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCountCommittedTransactions() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            TransactionCounters counts = (TransactionCounters)db.getDependencyResolver().resolveDependency(TransactionCounters.class);
            TransactionCountersChecker checker = new TransactionCountersChecker(counts);
            try (Transaction tx = db.beginTx();){
                this.dbConsumer.accept((Object)db);
                tx.success();
            }
            checker.verifyCommitted(this.isWriteTx, counts);
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCountRolledBackTransactions() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            TransactionCounters counts = (TransactionCounters)db.getDependencyResolver().resolveDependency(TransactionCounters.class);
            TransactionCountersChecker checker = new TransactionCountersChecker(counts);
            try (Transaction tx = db.beginTx();){
                this.dbConsumer.accept((Object)db);
                tx.failure();
            }
            checker.verifyRolledBacked(this.isWriteTx, counts);
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCountTerminatedTransactions() throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            TransactionCounters counts = (TransactionCounters)db.getDependencyResolver().resolveDependency(TransactionCounters.class);
            TransactionCountersChecker checker = new TransactionCountersChecker(counts);
            try (Transaction tx = db.beginTx();){
                this.dbConsumer.accept((Object)db);
                tx.terminate();
            }
            checker.verifyTerminated(this.isWriteTx, counts);
        }
        finally {
            db.shutdown();
        }
    }
}

