/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandExtractor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.TestGraphDatabaseFactory;

public class LabelAndIndexUpdateBatchingIT {
    private static final String PROPERTY_KEY = "key";
    private static final Label LABEL = Label.label((String)"label");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void indexShouldIncludeNodesCreatedPreviouslyInBatch() throws Exception {
        List<TransactionRepresentation> transactions;
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        String nodeN = "our guy";
        String otherNode = "just to create the tokens";
        try {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{LABEL}).setProperty(PROPERTY_KEY, (Object)otherNode);
                for (int i = 0; i < 10000; ++i) {
                    db.createNode();
                }
                tx.success();
            }
            tx = db.beginTx();
            var6_5 = null;
            try {
                db.createNode(new Label[]{LABEL}).setProperty(PROPERTY_KEY, (Object)nodeN);
                tx.success();
            }
            catch (Throwable i) {
                var6_5 = i;
                throw i;
            }
            finally {
                if (tx != null) {
                    if (var6_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable i) {
                            var6_5.addSuppressed(i);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            tx = db.beginTx();
            var6_5 = null;
            try {
                db.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
                tx.success();
            }
            catch (Throwable i) {
                var6_5 = i;
                throw i;
            }
            finally {
                if (tx != null) {
                    if (var6_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable i) {
                            var6_5.addSuppressed(i);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            transactions = LabelAndIndexUpdateBatchingIT.extractTransactions(db);
        }
        finally {
            db.shutdown();
        }
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        TransactionCommitProcess commitProcess = (TransactionCommitProcess)db.getDependencyResolver().resolveDependency(TransactionCommitProcess.class);
        try {
            int cutoffIndex = LabelAndIndexUpdateBatchingIT.findCutoffIndex(transactions);
            commitProcess.commit(LabelAndIndexUpdateBatchingIT.toApply(transactions.subList(0, cutoffIndex)), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            commitProcess.commit(LabelAndIndexUpdateBatchingIT.toApply(transactions.subList(cutoffIndex, transactions.size())), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            try (Transaction tx = db.beginTx();){
                Assert.assertNotNull((String)"Verification node not found", (Object)Iterators.singleOrNull((Iterator)db.findNodes(LABEL, PROPERTY_KEY, (Object)otherNode)));
                Assert.assertNotNull((String)"Node N not found", (Object)Iterators.singleOrNull((Iterator)db.findNodes(LABEL, PROPERTY_KEY, (Object)nodeN)));
                tx.success();
            }
        }
        finally {
            db.shutdown();
        }
    }

    private static int findCutoffIndex(Collection<TransactionRepresentation> transactions) throws IOException {
        Iterator<TransactionRepresentation> iterator = transactions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            TransactionRepresentation tx = iterator.next();
            CommandExtractor extractor = new CommandExtractor();
            tx.accept((Visitor)extractor);
            List commands = extractor.getCommands();
            List nodeCommands = commands.stream().filter(command -> command instanceof Command.NodeCommand).collect(Collectors.toList());
            if (nodeCommands.size() == 1) {
                return i;
            }
            ++i;
        }
        throw new AssertionError((Object)"Couldn't find the transaction which would be the cut-off point");
    }

    private static TransactionToApply toApply(Collection<TransactionRepresentation> transactions) {
        TransactionToApply first = null;
        TransactionToApply last = null;
        for (TransactionRepresentation transactionRepresentation : transactions) {
            TransactionToApply transaction = new TransactionToApply(transactionRepresentation);
            if (first == null) {
                first = last = transaction;
                continue;
            }
            last.next(transaction);
            last = transaction;
        }
        return first;
    }

    private static List<TransactionRepresentation> extractTransactions(GraphDatabaseAPI db) throws IOException {
        LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        ArrayList<TransactionRepresentation> transactions = new ArrayList<TransactionRepresentation>();
        try (TransactionCursor cursor = txStore.getTransactions(2L);){
            cursor.forAll(tx -> transactions.add(tx.getTransactionRepresentation()));
        }
        return transactions;
    }
}

