/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class TestTxEntries {
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.testDirectory);

    @Test
    public void testStartEntryWrittenOnceOnRollback() throws Exception {
        File storeDir = this.testDirectory.databaseDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(storeDir);
        this.createSomeTransactions(db);
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot(() -> ((GraphDatabaseService)db).shutdown());
        new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)snapshot).newImpermanentDatabase(storeDir).shutdown();
    }

    private void createSomeTransactions(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        node1.createRelationshipTo(node2, RelationshipType.withName((String)"relType1"));
        tx.success();
        tx.close();
        tx = db.beginTx();
        node1.delete();
        tx.success();
        try {
            tx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        tx = db.beginTx();
        node1.setProperty("foo", (Object)"bar");
        tx.success();
        tx.close();
    }
}

