/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class LogPruningIT {
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.keep_logical_logs, "true");
    private static final SimpleTriggerInfo triggerInfo = new SimpleTriggerInfo("forced trigger");

    @Test
    public void pruningStrategyShouldBeDynamic() throws IOException {
        CheckPointer checkPointer = this.getInstanceFromDb(CheckPointer.class);
        Config config = this.getInstanceFromDb(Config.class);
        FileSystemAbstraction fs = this.getInstanceFromDb(FileSystemAbstraction.class);
        LogFiles logFiles = LogFilesBuilder.builder((DatabaseLayout)this.db.databaseLayout(), (FileSystemAbstraction)fs).withLogVersionRepository((LogVersionRepository)new SimpleLogVersionRepository()).withLastCommittedTransactionIdSupplier(() -> 1L).withTransactionIdStore((TransactionIdStore)new SimpleTransactionIdStore()).build();
        this.writeTransactionsAndRotateTwice();
        checkPointer.forceCheckPoint((TriggerInfo)triggerInfo);
        Assert.assertThat((Object)this.countTransactionLogs(logFiles), (Matcher)CoreMatchers.is((Object)3));
        config.updateDynamicSetting(GraphDatabaseSettings.keep_logical_logs.name(), "false", "test");
        checkPointer.forceCheckPoint((TriggerInfo)triggerInfo);
        Assert.assertThat((Object)this.countTransactionLogs(logFiles), (Matcher)CoreMatchers.is((Object)2));
    }

    private void writeTransactionsAndRotateTwice() throws IOException {
        LogRotation logRotation = (LogRotation)this.db.getDependencyResolver().resolveDependency(LogRotation.class);
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode();
            tx.success();
        }
        logRotation.rotateLogFile();
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            this.db.createNode();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        logRotation.rotateLogFile();
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            this.db.createNode();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            this.db.createNode();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private <T> T getInstanceFromDb(Class<T> clazz) {
        return (T)this.db.getDependencyResolver().resolveDependency(clazz);
    }

    private int countTransactionLogs(LogFiles logFiles) {
        return logFiles.logFiles().length;
    }
}

