/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestLogPruning {
    private GraphDatabaseAPI db;
    private FileSystemAbstraction fs;
    private LogFiles files;
    private int rotateEveryNTransactions;
    private int performedTransactions;

    @After
    public void after() throws Exception {
        if (this.db != null) {
            this.db.shutdown();
        }
        this.fs.close();
    }

    @Test
    public void noPruning() throws Exception {
        this.newDb("true", 2);
        for (int i = 0; i < 100; ++i) {
            this.doTransaction();
        }
        long currentVersion = this.files.getHighestLogVersion();
        for (long version = 0L; version < currentVersion; ++version) {
            Assert.assertTrue((String)("Version " + version + " has been unexpectedly pruned"), (boolean)this.fs.fileExists(this.files.getLogFileForVersion(version)));
        }
    }

    @Test
    public void pruneByFileSize() throws Exception {
        int transactionByteSize = this.figureOutSampleTransactionSizeBytes();
        int transactionsPerFile = 3;
        int logThreshold = transactionByteSize * transactionsPerFile;
        this.newDb(logThreshold + " size", 1);
        for (int i = 0; i < 100; ++i) {
            this.doTransaction();
        }
        int totalLogFileSize = this.logFileSize();
        double totalTransactions = (double)totalLogFileSize / (double)transactionByteSize;
        Assert.assertTrue((totalTransactions >= 3.0 && totalTransactions < 4.0 ? 1 : 0) != 0);
    }

    @Test
    public void pruneByFileCount() throws Exception {
        int logsToKeep = 5;
        this.newDb(logsToKeep + " files", 3);
        for (int i = 0; i < 100; ++i) {
            this.doTransaction();
        }
        Assert.assertEquals((long)logsToKeep, (long)this.logCount());
    }

    @Test
    public void pruneByTransactionCount() throws Exception {
        int transactionsToKeep = 100;
        int transactionsPerLog = 3;
        this.newDb(transactionsToKeep + " txs", 3);
        for (int i = 0; i < 100; ++i) {
            this.doTransaction();
        }
        int transactionCount = this.transactionCount();
        Assert.assertTrue((String)("Transaction count expected to be within " + transactionsToKeep + " <= txs <= " + (transactionsToKeep + transactionsPerLog) + ", but was " + transactionCount), (transactionCount >= transactionsToKeep && transactionCount <= transactionsToKeep + transactionsPerLog ? 1 : 0) != 0);
    }

    @Test
    public void shouldKeepAtLeastOneTransactionAfterRotate() throws Exception {
        this.newDb("1 size", 1);
        for (int i = 0; i < 2; ++i) {
            this.doTransaction();
        }
        ((LogRotation)this.db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
        Assert.assertThat((Object)this.transactionCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    private GraphDatabaseAPI newDb(String logPruning, int rotateEveryNTransactions) {
        this.rotateEveryNTransactions = rotateEveryNTransactions;
        this.fs = new EphemeralFileSystemAbstraction();
        TestGraphDatabaseFactory gdf = new TestGraphDatabaseFactory();
        gdf.setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fs));
        GraphDatabaseBuilder builder = gdf.newImpermanentDatabaseBuilder();
        builder.setConfig(GraphDatabaseSettings.keep_logical_logs, logPruning);
        this.db = (GraphDatabaseAPI)builder.newGraphDatabase();
        this.files = (LogFiles)this.db.getDependencyResolver().resolveDependency(LogFiles.class);
        return this.db;
    }

    private void doTransaction() throws IOException {
        if (++this.performedTransactions >= this.rotateEveryNTransactions) {
            ((LogRotation)this.db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
            this.performedTransactions = 0;
        }
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.setProperty("name", (Object)"a somewhat lengthy string of some sort, right?");
            tx.success();
        }
        this.checkPoint();
    }

    private void checkPoint() throws IOException {
        SimpleTriggerInfo triggerInfo = new SimpleTriggerInfo("test");
        ((CheckPointer)this.db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)triggerInfo);
    }

    private int figureOutSampleTransactionSizeBytes() throws IOException {
        this.db = this.newDb("true", 5);
        this.doTransaction();
        this.db.shutdown();
        return (int)this.fs.getFileSize(this.files.getLogFileForVersion(0L));
    }

    private int aggregateLogData(Extractor extractor) throws IOException {
        int total = 0;
        for (long i = this.files.getHighestLogVersion(); i >= 0L && this.files.versionExists(i); --i) {
            total += extractor.extract(i);
        }
        return total;
    }

    private int logCount() throws IOException {
        return this.aggregateLogData(from -> 1);
    }

    private int logFileSize() throws IOException {
        return this.aggregateLogData(from -> (int)this.fs.getFileSize(this.files.getLogFileForVersion(from)));
    }

    private int transactionCount() throws IOException {
        return this.aggregateLogData(version -> {
            int counter = 0;
            LogVersionBridge bridge = channel -> channel;
            PhysicalLogVersionedStoreChannel versionedStoreChannel = this.files.openForVersion(version);
            try (ReadAheadLogChannel channel2 = new ReadAheadLogChannel((LogVersionedStoreChannel)versionedStoreChannel, bridge, 1000);
                 PhysicalTransactionCursor physicalTransactionCursor = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)channel2, (LogEntryReader)new VersionAwareLogEntryReader());){
                while (physicalTransactionCursor.next()) {
                    ++counter;
                }
            }
            return counter;
        });
    }

    private static interface Extractor {
        public int extract(long var1) throws IOException;
    }
}

