/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.TestDirectory;

public class NeoStoreFileListingTest {
    @Rule
    public final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private NeoStoreDataSource neoStoreDataSource;
    private static final String[] STANDARD_STORE_DIR_FILES = new String[]{"index", "lock", "debug.log", "neostore", "neostore.id", "neostore.counts.db.a", "neostore.counts.db.b", "neostore.labelscanstore.db", "neostore.labeltokenstore.db", "neostore.labeltokenstore.db.id", "neostore.labeltokenstore.db.names", "neostore.labeltokenstore.db.names.id", "neostore.nodestore.db", "neostore.nodestore.db.id", "neostore.nodestore.db.labels", "neostore.nodestore.db.labels.id", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.arrays.id", "neostore.propertystore.db.id", "neostore.propertystore.db.index", "neostore.propertystore.db.index.id", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.index.keys.id", "neostore.propertystore.db.strings", "neostore.propertystore.db.strings.id", "neostore.relationshipgroupstore.db", "neostore.relationshipgroupstore.db.id", "neostore.relationshipstore.db", "neostore.relationshipstore.db.id", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.id", "neostore.relationshiptypestore.db.names", "neostore.relationshiptypestore.db.names.id", "neostore.schemastore.db", "neostore.schemastore.db.id", "neostore.transaction.db.0", "neostore.transaction.db.1", "neostore.transaction.db.2", "store_lock"};
    private static final String[] STANDARD_STORE_DIR_DIRECTORIES = new String[]{"schema", "index", "branched"};

    @Before
    public void setUp() throws IOException {
        this.createIndexDbFile();
        this.neoStoreDataSource = (NeoStoreDataSource)this.db.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
    }

    @Test
    public void shouldCloseIndexAndLabelScanSnapshots() throws Exception {
        LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        ExplicitIndexProvider explicitIndexes = (ExplicitIndexProvider)Mockito.mock(ExplicitIndexProvider.class);
        Mockito.when((Object)explicitIndexes.allIndexProviders()).thenReturn(Collections.emptyList());
        DatabaseLayout databaseLayout = (DatabaseLayout)Mockito.mock(DatabaseLayout.class);
        Mockito.when((Object)databaseLayout.metadataStore()).thenReturn(Mockito.mock(File.class));
        LogFiles logFiles = (LogFiles)Mockito.mock(LogFiles.class);
        NeoStoreFileListingTest.filesInStoreDirAre(databaseLayout, STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        NeoStoreFileListing fileListing = new NeoStoreFileListing(databaseLayout, logFiles, labelScanStore, indexingService, explicitIndexes, storageEngine);
        ResourceIterator<File> scanSnapshot = NeoStoreFileListingTest.scanStoreFilesAre(labelScanStore, new String[]{"blah/scan.store", "scan.more"});
        ResourceIterator<File> indexSnapshot = NeoStoreFileListingTest.indexFilesAre(indexingService, new String[]{"schema/index/my.index"});
        ResourceIterator result = fileListing.builder().excludeLogFiles().build();
        result.close();
        ((ResourceIterator)Mockito.verify(scanSnapshot)).close();
        ((ResourceIterator)Mockito.verify(indexSnapshot)).close();
    }

    @Test
    public void shouldListMetaDataStoreLast() throws Exception {
        StoreFileMetadata fileMetadata = (StoreFileMetadata)Iterators.last((Iterator)this.neoStoreDataSource.listStoreFiles(false));
        Assert.assertEquals((Object)fileMetadata.file(), (Object)this.neoStoreDataSource.getDatabaseLayout().metadataStore());
    }

    @Test
    public void shouldListMetaDataStoreLastWithTxLogs() throws Exception {
        StoreFileMetadata fileMetadata = (StoreFileMetadata)Iterators.last((Iterator)this.neoStoreDataSource.listStoreFiles(true));
        Assert.assertEquals((Object)fileMetadata.file(), (Object)this.neoStoreDataSource.getDatabaseLayout().metadataStore());
    }

    @Test
    public void shouldListTransactionLogsFromCustomLocationWhenConfigured() throws IOException {
        String logFilesPath = "customTxFolder";
        this.verifyLogFilesWithCustomPathListing(logFilesPath);
    }

    @Test
    public void shouldListTransactionLogsFromCustomAbsoluteLocationWhenConfigured() throws IOException {
        File customLogLocation = this.testDirectory.directory("customLogLocation");
        this.verifyLogFilesWithCustomPathListing(customLogLocation.getAbsolutePath());
    }

    @Test
    public void shouldListTxLogFiles() throws Exception {
        Assert.assertTrue((boolean)this.neoStoreDataSource.listStoreFiles(true).stream().map(metaData -> metaData.file().getName()).anyMatch(fileName -> TransactionLogFiles.DEFAULT_FILENAME_FILTER.accept(null, (String)fileName)));
    }

    @Test
    public void shouldNotListTxLogFiles() throws Exception {
        Assert.assertTrue((boolean)this.neoStoreDataSource.listStoreFiles(false).stream().map(metaData -> metaData.file().getName()).noneMatch(fileName -> TransactionLogFiles.DEFAULT_FILENAME_FILTER.accept(null, (String)fileName)));
    }

    @Test
    public void shouldListNeostoreFiles() throws Exception {
        DatabaseLayout layout = this.neoStoreDataSource.getDatabaseLayout();
        Set expectedFiles = layout.storeFiles();
        expectedFiles.remove(layout.countStoreB());
        ResourceIterator storeFiles = this.neoStoreDataSource.listStoreFiles(false);
        Set listedStoreFiles = storeFiles.stream().map(StoreFileMetadata::file).filter(file -> !file.getName().equals("index.db")).collect(Collectors.toSet());
        Assert.assertEquals((Object)expectedFiles, listedStoreFiles);
    }

    @Test
    public void doNotListFilesFromAdditionalProviderThatRegisterTwice() throws IOException {
        NeoStoreFileListing neoStoreFileListing = this.neoStoreDataSource.getNeoStoreFileListing();
        MarkerFileProvider provider = new MarkerFileProvider();
        neoStoreFileListing.registerStoreFileProvider((NeoStoreFileListing.StoreFileProvider)provider);
        neoStoreFileListing.registerStoreFileProvider((NeoStoreFileListing.StoreFileProvider)provider);
        ResourceIterator metadataResourceIterator = neoStoreFileListing.builder().build();
        Assert.assertEquals((long)1L, (long)metadataResourceIterator.stream().filter(metadata -> "marker".equals(metadata.file().getName())).count());
    }

    private void verifyLogFilesWithCustomPathListing(String path) throws IOException {
        GraphDatabaseAPI graphDatabase = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.databaseDir("customDb")).setConfig(GraphDatabaseSettings.logical_logs_location, path).newGraphDatabase();
        NeoStoreDataSource dataSource = (NeoStoreDataSource)graphDatabase.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
        LogFiles logFiles = (LogFiles)graphDatabase.getDependencyResolver().resolveDependency(LogFiles.class);
        Assert.assertTrue((boolean)dataSource.listStoreFiles(true).stream().anyMatch(metadata -> metadata.isLogFile() && logFiles.isLogFile(metadata.file())));
        Assert.assertEquals((Object)Paths.get(path, new String[0]).getFileName().toString(), (Object)logFiles.logFilesDirectory().getName());
        graphDatabase.shutdown();
    }

    private static void filesInStoreDirAre(DatabaseLayout databaseLayout, String[] filenames, String[] dirs) {
        ArrayList<File> files = new ArrayList<File>();
        NeoStoreFileListingTest.mockFiles(filenames, files, false);
        NeoStoreFileListingTest.mockFiles(dirs, files, true);
        Mockito.when((Object)databaseLayout.listDatabaseFiles((FilenameFilter)ArgumentMatchers.any())).thenReturn((Object)files.toArray(new File[files.size()]));
    }

    private static ResourceIterator<File> scanStoreFilesAre(LabelScanStore labelScanStore, String[] fileNames) {
        ArrayList<File> files = new ArrayList<File>();
        NeoStoreFileListingTest.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)labelScanStore.snapshotStoreFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private static ResourceIterator<File> indexFilesAre(IndexingService indexingService, String[] fileNames) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        NeoStoreFileListingTest.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)indexingService.snapshotIndexFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private void createIndexDbFile() throws IOException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        File indexFile = databaseLayout.file("index.db");
        if (!indexFile.exists()) {
            Assert.assertTrue((boolean)indexFile.createNewFile());
        }
    }

    private static void mockFiles(String[] filenames, ArrayList<File> files, boolean isDirectories) {
        for (String filename : filenames) {
            File file = (File)Mockito.mock(File.class);
            String[] fileNameParts = filename.split("/");
            Mockito.when((Object)file.getName()).thenReturn((Object)fileNameParts[fileNameParts.length - 1]);
            Mockito.when((Object)file.isFile()).thenReturn((Object)(!isDirectories ? 1 : 0));
            Mockito.when((Object)file.isDirectory()).thenReturn((Object)isDirectories);
            Mockito.when((Object)file.exists()).thenReturn((Object)true);
            Mockito.when((Object)file.getPath()).thenReturn((Object)filename);
            files.add(file);
        }
    }

    private static class MarkerFileProvider
    implements NeoStoreFileListing.StoreFileProvider {
        private MarkerFileProvider() {
        }

        public Resource addFilesTo(Collection<StoreFileMetadata> fileMetadataCollection) {
            fileMetadataCollection.add(new StoreFileMetadata(new File("marker"), 0));
            return Resource.EMPTY;
        }
    }
}

