/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipCreator;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RelationshipGroupGetter;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RecordAccessSet;
import org.neo4j.kernel.impl.transaction.state.TrackingRecordAccess;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccessSet;

public class RelationshipCreatorTest {
    private static final int DENSE_NODE_THRESHOLD = 5;
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule().withSetting(GraphDatabaseSettings.dense_node_threshold, String.valueOf(5));
    private IdGeneratorFactory idGeneratorFactory;

    @Before
    public void before() {
        this.idGeneratorFactory = (IdGeneratorFactory)this.dbRule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(IdGeneratorFactory.class);
    }

    @Test
    public void shouldOnlyChangeLockedRecordsWhenUpgradingToDenseNode() {
        long nodeId = this.createNodeWithRelationships(5);
        NeoStores neoStores = this.flipToNeoStores();
        Tracker tracker = new Tracker(neoStores);
        RelationshipGroupGetter groupGetter = new RelationshipGroupGetter((IdSequence)neoStores.getRelationshipGroupStore());
        RelationshipCreator relationshipCreator = new RelationshipCreator(groupGetter, 5);
        relationshipCreator.relationshipCreate(this.idGeneratorFactory.get(IdType.RELATIONSHIP).nextId(), 0, nodeId, nodeId, (RecordAccessSet)tracker, (ResourceLocker)tracker);
        Assert.assertEquals((long)tracker.relationshipLocksAcquired.size(), (long)tracker.changedRelationships.size());
        Assert.assertFalse((boolean)tracker.relationshipLocksAcquired.isEmpty());
    }

    private NeoStores flipToNeoStores() {
        return ((RecordStorageEngine)this.dbRule.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
    }

    private long createNodeWithRelationships(int count) {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            for (int i = 0; i < count; ++i) {
                node.createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            }
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    static class Tracker
    extends NoOpClient
    implements RecordAccessSet {
        private final RecordAccessSet delegate;
        private final TrackingRecordAccess<RelationshipRecord, Void> relRecords;
        private final Set<Long> relationshipLocksAcquired = new HashSet<Long>();
        private final Set<Long> changedRelationships = new HashSet<Long>();

        Tracker(NeoStores neoStores) {
            this.delegate = new DirectRecordAccessSet(neoStores);
            this.relRecords = new TrackingRecordAccess(this.delegate.getRelRecords(), this);
        }

        public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
            Assert.assertEquals((Object)ResourceTypes.RELATIONSHIP, (Object)resourceType);
            for (long resourceId : resourceIds) {
                this.relationshipLocksAcquired.add(resourceId);
            }
        }

        protected void changingRelationship(long relId) {
            Assert.assertTrue((String)("Tried to change relationship " + relId + " without this transaction having it locked"), (boolean)this.relationshipLocksAcquired.contains(relId));
            this.changedRelationships.add(relId);
        }

        public RecordAccess<NodeRecord, Void> getNodeRecords() {
            return this.delegate.getNodeRecords();
        }

        public RecordAccess<PropertyRecord, PrimitiveRecord> getPropertyRecords() {
            return this.delegate.getPropertyRecords();
        }

        public RecordAccess<RelationshipRecord, Void> getRelRecords() {
            return this.relRecords;
        }

        public RecordAccess<RelationshipGroupRecord, Integer> getRelGroupRecords() {
            return this.delegate.getRelGroupRecords();
        }

        public RecordAccess<SchemaRecord, SchemaRule> getSchemaRuleChanges() {
            return this.delegate.getSchemaRuleChanges();
        }

        public RecordAccess<PropertyKeyTokenRecord, Void> getPropertyKeyTokenChanges() {
            return this.delegate.getPropertyKeyTokenChanges();
        }

        public RecordAccess<LabelTokenRecord, Void> getLabelTokenChanges() {
            return this.delegate.getLabelTokenChanges();
        }

        public RecordAccess<RelationshipTypeTokenRecord, Void> getRelationshipTypeTokenChanges() {
            return this.delegate.getRelationshipTypeTokenChanges();
        }

        public void close() {
            this.delegate.close();
        }

        public boolean hasChanges() {
            return this.delegate.hasChanges();
        }

        public int changeSize() {
            return this.delegate.changeSize();
        }
    }
}

