/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class DepthOneTraversalTest
extends TraversalTestBase {
    private Transaction tx;

    @Before
    public void createTheGraph() {
        this.createGraph("0 ROOT 1", "1 KNOWS 2", "2 KNOWS 3", "2 KNOWS 4", "4 KNOWS 5", "5 KNOWS 6", "3 KNOWS 1");
        this.tx = this.beginTx();
    }

    @After
    public void tearDown() {
        this.tx.close();
    }

    private void shouldGetBothNodesOnDepthOne(TraversalDescription description) {
        description = description.evaluator(Evaluators.atDepth((int)1));
        this.expectNodes(description.traverse(this.getNodeWithName("3")), "1", "2");
    }

    @Test
    public void shouldGetBothNodesOnDepthOneForDepthFirst() {
        this.shouldGetBothNodesOnDepthOne(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void shouldGetBothNodesOnDepthOneForBreadthFirst() {
        this.shouldGetBothNodesOnDepthOne(this.getGraphDb().traversalDescription().breadthFirst());
    }
}

