/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestBranchState
extends TraversalTestBase {
    @Test
    public void depthAsState() {
        this.createGraph("a to b", "b to c", "c to d", "b to e", "e to f", "f to d", "f to g", "g to h");
        try (Transaction tx = this.beginTx();){
            DepthStateExpander expander = new DepthStateExpander();
            Iterables.count((Iterable)this.getGraphDb().traversalDescription().expand((PathExpander)expander, (InitialBranchState)new InitialBranchState.State((Object)0, (Object)0)).traverse(this.getNodeWithName("a")));
            tx.success();
        }
    }

    @Test
    public void everyOtherDepthAsState() {
        this.createGraph("a to b", "b to c", "c to d", "d to e");
        try (Transaction tx = this.beginTx();){
            IncrementEveryOtherDepthCountingExpander expander = new IncrementEveryOtherDepthCountingExpander();
            Iterables.count((Iterable)this.getGraphDb().traversalDescription().expand((PathExpander)expander, (InitialBranchState)new InitialBranchState.State((Object)0, (Object)0)).traverse(this.getNodeWithName("a")));
            tx.success();
        }
    }

    @Test
    public void evaluateState() {
        this.createGraph("a TO b", "b TO c", "c TO d", "a TO e", "e TO f", "f TO c");
        try (Transaction tx = this.beginTx();){
            PathEvaluator.Adapter<Integer> evaluator = new PathEvaluator.Adapter<Integer>(){

                public Evaluation evaluate(Path path, BranchState<Integer> state) {
                    return Evaluation.ofIncludes((path.endNode().getProperty("name").equals("c") && (Integer)state.getState() == 3 ? 1 : 0) != 0);
                }
            };
            this.expectPaths(this.getGraphDb().traversalDescription().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).expand((PathExpander)new RelationshipWeightExpander(), (InitialBranchState)new InitialBranchState.State((Object)1, (Object)1)).evaluator((PathEvaluator)evaluator).traverse(this.getNodeWithName("a")), "a,b,c");
            tx.success();
        }
    }

    private static class RelationshipWeightExpander
    implements PathExpander<Integer> {
        private RelationshipWeightExpander() {
        }

        public Iterable<Relationship> expand(Path path, BranchState<Integer> state) {
            state.setState((Object)((Integer)state.getState() + 1));
            return path.endNode().getRelationships(Direction.OUTGOING);
        }

        public PathExpander<Integer> reverse() {
            return this;
        }
    }

    private static class IncrementEveryOtherDepthCountingExpander
    implements PathExpander<Integer> {
        private IncrementEveryOtherDepthCountingExpander() {
        }

        public Iterable<Relationship> expand(Path path, BranchState<Integer> state) {
            Assert.assertEquals((long)(path.length() / 2), (long)((Integer)state.getState()).intValue());
            if (path.length() % 2 == 1) {
                state.setState((Object)((Integer)state.getState() + 1));
            }
            return path.endNode().getRelationships(Direction.OUTGOING);
        }

        public PathExpander<Integer> reverse() {
            return this;
        }
    }

    private static class DepthStateExpander
    implements PathExpander<Integer> {
        private DepthStateExpander() {
        }

        public Iterable<Relationship> expand(Path path, BranchState<Integer> state) {
            Assert.assertEquals((long)path.length(), (long)((Integer)state.getState()).intValue());
            state.setState((Object)((Integer)state.getState() + 1));
            return path.endNode().getRelationships(Direction.OUTGOING);
        }

        public PathExpander<Integer> reverse() {
            return this;
        }
    }
}

