/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestMultiRelTypesAndDirections
extends TraversalTestBase {
    private static final RelationshipType ONE = RelationshipType.withName((String)"ONE");

    @Before
    public void setupGraph() {
        this.createGraph("A ONE B", "B ONE C", "A TWO C");
    }

    @Test
    public void testCIsReturnedOnDepthTwoDepthFirst() {
        this.testCIsReturnedOnDepthTwo(this.getGraphDb().traversalDescription().depthFirst());
    }

    @Test
    public void testCIsReturnedOnDepthTwoBreadthFirst() {
        this.testCIsReturnedOnDepthTwo(this.getGraphDb().traversalDescription().breadthFirst());
    }

    private void testCIsReturnedOnDepthTwo(TraversalDescription description) {
        try (Transaction transaction = this.beginTx();){
            description = description.expand(PathExpanders.forTypeAndDirection((RelationshipType)ONE, (Direction)Direction.OUTGOING));
            int i = 0;
            for (Path position : description.traverse(this.node("A"))) {
                Assert.assertEquals((long)i++, (long)position.length());
            }
        }
    }
}

