/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.junit.Assert;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.test.GraphDefinition;
import org.neo4j.test.GraphDescription;

public abstract class TraversalTestBase
extends AbstractNeo4jTestCase {
    private Map<String, Node> nodes;
    protected static final Representation<PropertyContainer> NAME_PROPERTY_REPRESENTATION = new PropertyRepresentation("name");
    protected static final Representation<Relationship> RELATIONSHIP_TYPE_REPRESENTATION = item -> item.getType().name();

    @Override
    protected boolean restartGraphDbBetweenTests() {
        return true;
    }

    protected Node node(String name) {
        return this.nodes.get(name);
    }

    protected Node getNode(long id) {
        return this.getGraphDb().getNodeById(id);
    }

    protected Transaction beginTx() {
        return this.getGraphDb().beginTx();
    }

    protected void createGraph(String ... description) {
        this.nodes = this.createGraph((GraphDefinition)GraphDescription.create((String[])description));
    }

    private Map<String, Node> createGraph(GraphDefinition graph) {
        try (Transaction tx = this.beginTx();){
            Map result = graph.create(this.getGraphDb());
            tx.success();
            Map map = result;
            return map;
        }
    }

    protected Node getNodeWithName(String name) {
        ResourceIterable allNodes = this.getGraphDb().getAllNodes();
        try (ResourceIterator nodeIterator = allNodes.iterator();){
            while (nodeIterator.hasNext()) {
                Node node = (Node)nodeIterator.next();
                String nodeName = (String)node.getProperty("name", null);
                if (nodeName == null || !nodeName.equals(name)) continue;
                Node node2 = node;
                return node2;
            }
        }
        return null;
    }

    protected void assertLevels(Traverser traverser, Stack<Set<String>> levels) {
        Set<String> current = levels.pop();
        for (Path position : traverser) {
            String nodeName = (String)position.endNode().getProperty("name");
            if (current.isEmpty()) {
                current = levels.pop();
            }
            Assert.assertTrue((String)("Should not contain node (" + nodeName + ") at level " + (3 - levels.size())), (boolean)current.remove(nodeName));
        }
        Assert.assertTrue((String)"Should have no more levels", (boolean)levels.isEmpty());
        Assert.assertTrue((String)"Should be empty", (boolean)current.isEmpty());
    }

    protected <T> void expect(Iterable<? extends T> items, Representation<T> representation, String ... expected) {
        this.expect(items, representation, new HashSet<String>(Arrays.asList(expected)));
    }

    protected <T> void expect(Iterable<? extends T> items, Representation<T> representation, Set<String> expected) {
        ArrayList<String> encounteredItems = new ArrayList<String>();
        try (Transaction tx = this.beginTx();){
            for (T item : items) {
                String repr = representation.represent(item);
                Assert.assertTrue((String)(repr + " not expected "), (boolean)expected.remove(repr));
                encounteredItems.add(repr);
            }
            tx.success();
        }
        if (!expected.isEmpty()) {
            Assert.fail((String)("The expected elements " + expected + " were not returned. Returned were: " + encounteredItems));
        }
    }

    protected void expectNodes(Traverser traverser, String ... nodes) {
        this.expect((Iterable)traverser.nodes(), (Representation)NAME_PROPERTY_REPRESENTATION, nodes);
    }

    protected void expectRelationships(Traverser traverser, String ... relationships) {
        this.expect((Iterable)traverser.relationships(), (Representation)new RelationshipRepresentation(NAME_PROPERTY_REPRESENTATION), relationships);
    }

    protected void expectPaths(Traverser traverser, String ... paths) {
        this.expectPaths(traverser, new HashSet<String>(Arrays.asList(paths)));
    }

    protected void expectPaths(Traverser traverser, Set<String> expected) {
        this.expect((Iterable)traverser, (Representation)new NodePathRepresentation(NAME_PROPERTY_REPRESENTATION), expected);
    }

    public static <E> void assertContains(Iterator<E> actual, E ... expected) {
        TraversalTestBase.assertContains(Iterators.asIterable(actual), expected);
    }

    public static <E> void assertContains(Iterable<E> actual, E ... expected) {
        HashSet<E> expectation = new HashSet<E>(Arrays.asList(expected));
        for (E element : actual) {
            if (expectation.remove(element)) continue;
            Assert.fail((String)("unexpected element <" + element + ">"));
        }
        if (!expectation.isEmpty()) {
            Assert.fail((String)("the expected elements <" + expectation + "> were not contained"));
        }
    }

    public static <T> void assertContainsInOrder(Collection<T> collection, T ... expectedItems) {
        String collectionString = TraversalTestBase.join(", ", collection.toArray());
        Assert.assertEquals((String)collectionString, (long)expectedItems.length, (long)collection.size());
        Iterator<T> itr = collection.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Assert.assertEquals(expectedItems[i], itr.next());
            ++i;
        }
    }

    public static <T> void assertContainsInOrder(Iterable<T> collection, T ... expectedItems) {
        TraversalTestBase.assertContainsInOrder(Iterables.asCollection(collection), expectedItems);
    }

    public static <T> String join(String delimiter, T ... items) {
        StringBuilder buffer = new StringBuilder();
        for (T item : items) {
            if (buffer.length() > 0) {
                buffer.append(delimiter);
            }
            buffer.append(item.toString());
        }
        return buffer.toString();
    }

    protected static final class NodePathRepresentation
    implements Representation<Path> {
        private final Representation<? super Node> nodes;

        public NodePathRepresentation(Representation<? super Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public String represent(Path item) {
            StringBuilder builder = new StringBuilder();
            for (Node node : item.nodes()) {
                builder.append(builder.length() > 0 ? "," : "");
                builder.append(this.nodes.represent((Node)node));
            }
            return builder.toString();
        }
    }

    protected static final class RelationshipRepresentation
    implements Representation<Relationship> {
        private final Representation<? super Node> nodes;
        private final Representation<? super Relationship> rel;

        public RelationshipRepresentation(Representation<? super Node> nodes) {
            this(nodes, RELATIONSHIP_TYPE_REPRESENTATION);
        }

        public RelationshipRepresentation(Representation<? super Node> nodes, Representation<? super Relationship> rel) {
            this.nodes = nodes;
            this.rel = rel;
        }

        @Override
        public String represent(Relationship item) {
            return this.nodes.represent((Node)item.getStartNode()) + " " + this.rel.represent((Relationship)item) + " " + this.nodes.represent((Node)item.getEndNode());
        }
    }

    protected static final class PropertyRepresentation
    implements Representation<PropertyContainer> {
        private final String key;

        public PropertyRepresentation(String key) {
            this.key = key;
        }

        @Override
        public String represent(PropertyContainer item) {
            return (String)item.getProperty(this.key);
        }
    }

    protected static interface Representation<T> {
        public String represent(T var1);
    }
}

