/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.locking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.ExecutionStatistics;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.ExplicitIndexWrite;
import org.neo4j.internal.kernel.api.Locks;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.Token;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.values.virtual.VirtualValues;

public class QueryExecutionLocksIT {
    @Rule
    public EmbeddedDatabaseRule databaseRule = new EmbeddedDatabaseRule();

    @Test
    public void noLocksTakenForQueryWithoutAnyIndexesUsage() throws Exception {
        String query = "MATCH (n) return count(n)";
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, new LockOperationListener[0]);
        Assert.assertThat((String)("Observed list of lock operations is: " + lockOperationRecords), lockOperationRecords, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void takeLabelLockForQueryWithIndexUsages() throws Exception {
        String labelName = "Human";
        Label human = Label.label((String)labelName);
        String propertyKey = "name";
        this.createIndex(human, propertyKey);
        try (Transaction transaction = this.databaseRule.beginTx();){
            Node node = this.databaseRule.createNode(new Label[]{human});
            node.setProperty(propertyKey, (Object)RandomStringUtils.randomAscii((int)10));
            transaction.success();
        }
        String query = "MATCH (n:" + labelName + ") where n." + propertyKey + " = \"Fry\" RETURN n ";
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, new LockOperationListener[0]);
        Assert.assertThat((String)("Observed list of lock operations is: " + lockOperationRecords), lockOperationRecords, (Matcher)Matchers.hasSize((int)1));
        LockOperationRecord operationRecord = lockOperationRecords.get(0);
        Assert.assertTrue((boolean)operationRecord.acquisition);
        Assert.assertFalse((boolean)operationRecord.exclusive);
        Assert.assertEquals((Object)ResourceTypes.LABEL, (Object)operationRecord.resourceType);
    }

    @Test
    public void reTakeLabelLockForQueryWithIndexUsagesWhenSchemaStateWasUpdatedDuringLockOperations() throws Exception {
        String labelName = "Robot";
        Label robot = Label.label((String)labelName);
        String propertyKey = "name";
        this.createIndex(robot, propertyKey);
        try (Transaction transaction = this.databaseRule.beginTx();){
            Node node = this.databaseRule.createNode(new Label[]{robot});
            node.setProperty(propertyKey, (Object)RandomStringUtils.randomAscii((int)10));
            transaction.success();
        }
        String query = "MATCH (n:" + labelName + ") where n." + propertyKey + " = \"Bender\" RETURN n ";
        OnceSchemaFlushListener lockOperationListener = new OnceSchemaFlushListener();
        List<LockOperationRecord> lockOperationRecords = this.traceQueryLocks(query, lockOperationListener);
        Assert.assertThat((String)("Observed list of lock operations is: " + lockOperationRecords), lockOperationRecords, (Matcher)Matchers.hasSize((int)3));
        LockOperationRecord operationRecord = lockOperationRecords.get(0);
        Assert.assertTrue((boolean)operationRecord.acquisition);
        Assert.assertFalse((boolean)operationRecord.exclusive);
        Assert.assertEquals((Object)ResourceTypes.LABEL, (Object)operationRecord.resourceType);
        LockOperationRecord operationRecord1 = lockOperationRecords.get(1);
        Assert.assertFalse((boolean)operationRecord1.acquisition);
        Assert.assertFalse((boolean)operationRecord1.exclusive);
        Assert.assertEquals((Object)ResourceTypes.LABEL, (Object)operationRecord1.resourceType);
        LockOperationRecord operationRecord2 = lockOperationRecords.get(2);
        Assert.assertTrue((boolean)operationRecord2.acquisition);
        Assert.assertFalse((boolean)operationRecord2.exclusive);
        Assert.assertEquals((Object)ResourceTypes.LABEL, (Object)operationRecord2.resourceType);
    }

    private void createIndex(Label label, String propertyKey) {
        try (Transaction transaction = this.databaseRule.beginTx();){
            this.databaseRule.schema().indexFor(label).on(propertyKey).create();
            transaction.success();
        }
        var4_4 = null;
        try (Transaction ignored = this.databaseRule.beginTx();){
            this.databaseRule.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private List<LockOperationRecord> traceQueryLocks(String query, LockOperationListener ... listeners) throws QueryExecutionKernelException {
        GraphDatabaseQueryService graph = (GraphDatabaseQueryService)this.databaseRule.resolveDependency(GraphDatabaseQueryService.class);
        QueryExecutionEngine executionEngine = (QueryExecutionEngine)this.databaseRule.resolveDependency(QueryExecutionEngine.class);
        try (InternalTransaction tx = graph.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);){
            TransactionalContextWrapper context = new TransactionalContextWrapper(this.createTransactionContext(graph, tx, query), listeners);
            executionEngine.executeQuery(query, VirtualValues.emptyMap(), (TransactionalContext)context);
            ArrayList<LockOperationRecord> arrayList = new ArrayList<LockOperationRecord>(context.recordingLocks.getLockOperationRecords());
            return arrayList;
        }
    }

    private TransactionalContext createTransactionContext(GraphDatabaseQueryService graph, InternalTransaction tx, String query) {
        PropertyContainerLocker locker = new PropertyContainerLocker();
        TransactionalContextFactory contextFactory = Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)graph, (PropertyContainerLocker)locker);
        return contextFactory.newContext(ClientConnectionInfo.EMBEDDED_CONNECTION, tx, query, VirtualValues.EMPTY_MAP);
    }

    private static class DelegatingTransaction
    implements KernelTransaction {
        private final KernelTransaction internal;
        private final Locks locks;

        DelegatingTransaction(KernelTransaction internal, Locks locks) {
            this.internal = internal;
            this.locks = locks;
        }

        public void success() {
            this.internal.success();
        }

        public void failure() {
            this.internal.failure();
        }

        public Read dataRead() {
            return this.internal.dataRead();
        }

        public Write dataWrite() throws InvalidTransactionTypeKernelException {
            return this.internal.dataWrite();
        }

        public ExplicitIndexRead indexRead() {
            return this.internal.indexRead();
        }

        public ExplicitIndexWrite indexWrite() throws InvalidTransactionTypeKernelException {
            return this.internal.indexWrite();
        }

        public TokenRead tokenRead() {
            return this.internal.tokenRead();
        }

        public TokenWrite tokenWrite() {
            return this.internal.tokenWrite();
        }

        public Token token() {
            return this.internal.token();
        }

        public SchemaRead schemaRead() {
            return this.internal.schemaRead();
        }

        public SchemaWrite schemaWrite() throws InvalidTransactionTypeKernelException {
            return this.internal.schemaWrite();
        }

        public Locks locks() {
            return this.locks;
        }

        public CursorFactory cursors() {
            return this.internal.cursors();
        }

        public Procedures procedures() {
            return this.internal.procedures();
        }

        public ExecutionStatistics executionStatistics() {
            return this.internal.executionStatistics();
        }

        public Statement acquireStatement() {
            return this.internal.acquireStatement();
        }

        public IndexDescriptor indexUniqueCreate(SchemaDescriptor schema, String provider) throws SchemaKernelException {
            String defaultProvider = (String)Config.defaults().get(GraphDatabaseSettings.default_schema_provider);
            return this.internal.indexUniqueCreate(schema, defaultProvider);
        }

        public long closeTransaction() throws TransactionFailureException {
            return this.internal.closeTransaction();
        }

        public void close() throws TransactionFailureException {
            this.internal.close();
        }

        public boolean isOpen() {
            return this.internal.isOpen();
        }

        public SecurityContext securityContext() {
            return this.internal.securityContext();
        }

        public AuthSubject subjectOrAnonymous() {
            return this.internal.subjectOrAnonymous();
        }

        public Optional<Status> getReasonIfTerminated() {
            return this.internal.getReasonIfTerminated();
        }

        public boolean isTerminated() {
            return this.internal.isTerminated();
        }

        public void markForTermination(Status reason) {
            this.internal.markForTermination(reason);
        }

        public long lastTransactionTimestampWhenStarted() {
            return this.internal.lastTransactionTimestampWhenStarted();
        }

        public long lastTransactionIdWhenStarted() {
            return this.internal.lastTransactionIdWhenStarted();
        }

        public long startTime() {
            return this.internal.startTime();
        }

        public long startTimeNanos() {
            return this.internal.startTimeNanos();
        }

        public long timeout() {
            return this.internal.timeout();
        }

        public void registerCloseListener(KernelTransaction.CloseListener listener) {
            this.internal.registerCloseListener(listener);
        }

        public Transaction.Type transactionType() {
            return this.internal.transactionType();
        }

        public long getTransactionId() {
            return this.internal.getTransactionId();
        }

        public long getCommitTime() {
            return this.internal.getCommitTime();
        }

        public KernelTransaction.Revertable overrideWith(SecurityContext context) {
            return this.internal.overrideWith(context);
        }

        public ClockContext clocks() {
            return this.internal.clocks();
        }

        public NodeCursor ambientNodeCursor() {
            return this.internal.ambientNodeCursor();
        }

        public RelationshipScanCursor ambientRelationshipCursor() {
            return this.internal.ambientRelationshipCursor();
        }

        public PropertyCursor ambientPropertyCursor() {
            return this.internal.ambientPropertyCursor();
        }

        public void setMetaData(Map<String, Object> metaData) {
            this.internal.setMetaData(metaData);
        }

        public Map<String, Object> getMetaData() {
            return this.internal.getMetaData();
        }

        public void assertOpen() {
            this.internal.assertOpen();
        }

        public boolean isSchemaTransaction() {
            return this.internal.isSchemaTransaction();
        }
    }

    private class OnceSchemaFlushListener
    extends LockOperationListener {
        private boolean executed;

        private OnceSchemaFlushListener() {
        }

        @Override
        void lockAcquired(boolean exclusive, ResourceType resourceType, long ... ids) {
            if (!this.executed) {
                ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)QueryExecutionLocksIT.this.databaseRule.resolveDependency(ThreadToStatementContextBridge.class);
                KernelTransaction ktx = bridge.getKernelTransactionBoundToThisThread(true);
                ktx.schemaRead().schemaStateFlush();
            }
            this.executed = true;
        }
    }

    private static class LockOperationRecord {
        private final boolean exclusive;
        private final boolean acquisition;
        private final ResourceType resourceType;
        private final long[] ids;

        LockOperationRecord(boolean exclusive, boolean acquisition, ResourceType resourceType, long[] ids) {
            this.exclusive = exclusive;
            this.acquisition = acquisition;
            this.resourceType = resourceType;
            this.ids = ids;
        }

        public String toString() {
            return "LockOperationRecord{exclusive=" + this.exclusive + ", acquisition=" + this.acquisition + ", resourceType=" + this.resourceType + ", ids=" + Arrays.toString(this.ids) + '}';
        }
    }

    private static class LockOperationListener
    implements EventListener {
        private LockOperationListener() {
        }

        void lockAcquired(boolean exclusive, ResourceType resourceType, long ... ids) {
        }
    }

    private static class RecordingLocks
    implements Locks {
        private final Locks delegate;
        private final List<LockOperationListener> listeners;
        private final List<LockOperationRecord> lockOperationRecords;

        private RecordingLocks(Locks delegate, List<LockOperationListener> listeners, List<LockOperationRecord> lockOperationRecords) {
            this.delegate = delegate;
            this.listeners = listeners;
            this.lockOperationRecords = lockOperationRecords;
        }

        List<LockOperationRecord> getLockOperationRecords() {
            return this.lockOperationRecords;
        }

        private void record(boolean exclusive, boolean acquisition, ResourceTypes type, long ... ids) {
            if (acquisition) {
                for (LockOperationListener listener : this.listeners) {
                    listener.lockAcquired(exclusive, (ResourceType)type, ids);
                }
            }
            this.lockOperationRecords.add(new LockOperationRecord(exclusive, acquisition, (ResourceType)type, ids));
        }

        public void acquireExclusiveNodeLock(long ... ids) {
            this.record(true, true, ResourceTypes.NODE, ids);
            this.delegate.acquireExclusiveNodeLock(ids);
        }

        public void acquireExclusiveRelationshipLock(long ... ids) {
            this.record(true, true, ResourceTypes.RELATIONSHIP, ids);
            this.delegate.acquireExclusiveRelationshipLock(ids);
        }

        public void acquireExclusiveExplicitIndexLock(long ... ids) {
            this.record(true, true, ResourceTypes.EXPLICIT_INDEX, ids);
            this.delegate.acquireExclusiveExplicitIndexLock(ids);
        }

        public void acquireExclusiveLabelLock(long ... ids) {
            this.record(true, true, ResourceTypes.LABEL, ids);
            this.delegate.acquireExclusiveLabelLock(ids);
        }

        public void releaseExclusiveNodeLock(long ... ids) {
            this.record(true, false, ResourceTypes.NODE, ids);
            this.delegate.releaseExclusiveNodeLock(ids);
        }

        public void releaseExclusiveRelationshipLock(long ... ids) {
            this.record(true, false, ResourceTypes.RELATIONSHIP, ids);
            this.delegate.releaseExclusiveRelationshipLock(ids);
        }

        public void releaseExclusiveExplicitIndexLock(long ... ids) {
            this.record(true, false, ResourceTypes.EXPLICIT_INDEX, ids);
            this.delegate.releaseExclusiveExplicitIndexLock(ids);
        }

        public void releaseExclusiveLabelLock(long ... ids) {
            this.record(true, false, ResourceTypes.LABEL, ids);
            this.delegate.releaseExclusiveLabelLock(ids);
        }

        public void acquireSharedNodeLock(long ... ids) {
            this.record(false, true, ResourceTypes.NODE, ids);
            this.delegate.acquireSharedNodeLock(ids);
        }

        public void acquireSharedRelationshipLock(long ... ids) {
            this.record(false, true, ResourceTypes.RELATIONSHIP, ids);
            this.delegate.acquireSharedRelationshipLock(ids);
        }

        public void acquireSharedExplicitIndexLock(long ... ids) {
            this.record(false, true, ResourceTypes.EXPLICIT_INDEX, ids);
            this.delegate.acquireSharedExplicitIndexLock(ids);
        }

        public void acquireSharedLabelLock(long ... ids) {
            this.record(false, true, ResourceTypes.LABEL, ids);
            this.delegate.acquireSharedLabelLock(ids);
        }

        public void releaseSharedNodeLock(long ... ids) {
            this.record(false, false, ResourceTypes.NODE, ids);
            this.delegate.releaseSharedNodeLock(ids);
        }

        public void releaseSharedRelationshipLock(long ... ids) {
            this.record(false, false, ResourceTypes.RELATIONSHIP, ids);
            this.delegate.releaseSharedRelationshipLock(ids);
        }

        public void releaseSharedExplicitIndexLock(long ... ids) {
            this.record(false, false, ResourceTypes.EXPLICIT_INDEX, ids);
            this.delegate.releaseSharedExplicitIndexLock(ids);
        }

        public void releaseSharedLabelLock(long ... ids) {
            this.record(false, false, ResourceTypes.LABEL, ids);
            this.delegate.releaseSharedLabelLock(ids);
        }
    }

    private static class TransactionalContextWrapper
    implements TransactionalContext {
        private final TransactionalContext delegate;
        private final List<LockOperationRecord> recordedLocks;
        private final LockOperationListener[] listeners;
        private RecordingLocks recordingLocks;

        private TransactionalContextWrapper(TransactionalContext delegate, LockOperationListener ... listeners) {
            this(delegate, new ArrayList<LockOperationRecord>(), listeners);
        }

        private TransactionalContextWrapper(TransactionalContext delegate, List<LockOperationRecord> recordedLocks, LockOperationListener ... listeners) {
            this.delegate = delegate;
            this.recordedLocks = recordedLocks;
            this.listeners = listeners;
        }

        public ExecutingQuery executingQuery() {
            return this.delegate.executingQuery();
        }

        public DbmsOperations dbmsOperations() {
            return this.delegate.dbmsOperations();
        }

        public KernelTransaction kernelTransaction() {
            if (this.recordingLocks == null) {
                this.recordingLocks = new RecordingLocks(this.delegate.kernelTransaction().locks(), Arrays.asList(this.listeners), this.recordedLocks);
            }
            return new DelegatingTransaction(this.delegate.kernelTransaction(), this.recordingLocks);
        }

        public boolean isTopLevelTx() {
            return this.delegate.isTopLevelTx();
        }

        public void close(boolean success) {
            this.delegate.close(success);
        }

        public void terminate() {
            this.delegate.terminate();
        }

        public void commitAndRestartTx() {
            this.delegate.commitAndRestartTx();
        }

        public void cleanForReuse() {
            this.delegate.cleanForReuse();
        }

        public TransactionalContext getOrBeginNewIfClosed() {
            if (this.isOpen()) {
                return this;
            }
            return new TransactionalContextWrapper(this.delegate.getOrBeginNewIfClosed(), this.recordedLocks, this.listeners);
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public GraphDatabaseQueryService graph() {
            return this.delegate.graph();
        }

        public Statement statement() {
            return this.delegate.statement();
        }

        public void check() {
            this.delegate.check();
        }

        public TxStateHolder stateView() {
            return this.delegate.stateView();
        }

        public Lock acquireWriteLock(PropertyContainer p) {
            return this.delegate.acquireWriteLock(p);
        }

        public SecurityContext securityContext() {
            return this.delegate.securityContext();
        }

        public StatisticProvider kernelStatisticProvider() {
            return this.delegate.kernelStatisticProvider();
        }

        public KernelTransaction.Revertable restrictCurrentTransaction(SecurityContext context) {
            return this.delegate.restrictCurrentTransaction(context);
        }

        public ResourceTracker resourceTracker() {
            return this.delegate.resourceTracker();
        }
    }
}

