/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestGraphDescription
implements GraphHolder {
    private static GraphDatabaseService graphdb;
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this, (boolean)true));

    @Test
    public void havingNoGraphAnnotationCreatesAnEmptyDataCollection() {
        Assert.assertTrue((String)"collection was not empty", (boolean)((Map)this.data.get()).isEmpty());
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void canCreateGraphFromSingleString() {
        this.verifyIKnowYou("know", "I");
    }

    @Test
    @GraphDescription.Graph(value={"a TO b", "b TO c", "c TO a"})
    public void canCreateGraphFromMultipleStrings() {
        Map graph = (Map)this.data.get();
        HashSet<Node> unique = new HashSet<Node>();
        Node n = (Node)graph.get("a");
        while (unique.add(n)) {
            Transaction ignored = graphdb.beginTx();
            Throwable throwable = null;
            try {
                n = n.getSingleRelationship(RelationshipType.withName((String)"TO"), Direction.OUTGOING).getEndNode();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        Assert.assertEquals((long)graph.size(), (long)unique.size());
    }

    @Test
    @GraphDescription.Graph(value={"a:Person EATS b:Banana"})
    public void ensurePeopleCanEatBananas() {
        Map graph = (Map)this.data.get();
        Node a = (Node)graph.get("a");
        Node b = (Node)graph.get("b");
        try (Transaction ignored = graphdb.beginTx();){
            Assert.assertTrue((boolean)a.hasLabel(Label.label((String)"Person")));
            Assert.assertTrue((boolean)b.hasLabel(Label.label((String)"Banana")));
        }
    }

    @Test
    @GraphDescription.Graph(value={"a:Person EATS b:Banana", "a EATS b:Apple"})
    public void ensurePeopleCanEatBananasAndApples() {
        Map graph = (Map)this.data.get();
        Node a = (Node)graph.get("a");
        Node b = (Node)graph.get("b");
        try (Transaction ignored = graphdb.beginTx();){
            Assert.assertTrue((String)"Person label missing", (boolean)a.hasLabel(Label.label((String)"Person")));
            Assert.assertTrue((String)"Banana label missing", (boolean)b.hasLabel(Label.label((String)"Banana")));
            Assert.assertTrue((String)"Apple label missing", (boolean)b.hasLabel(Label.label((String)"Apple")));
        }
    }

    @Test
    @GraphDescription.Graph(value={"I know you"}, autoIndexNodes=true)
    public void canAutoIndexNodes() {
        this.data.get();
        try (Transaction ignored = graphdb.beginTx();
             IndexHits indexHits = this.graphdb().index().getNodeAutoIndexer().getAutoIndex().get("name", (Object)"I");){
            Assert.assertTrue((String)"can't look up node.", (boolean)indexHits.hasNext());
        }
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", setNameProperty=true, properties={@GraphDescription.PROP(key="name", value="I")})}, autoIndexNodes=true)
    public void canAutoIndexNodesExplicitProps() {
        this.data.get();
        try (Transaction ignored = graphdb.beginTx();
             IndexHits nodes = this.graphdb().index().getNodeAutoIndexer().getAutoIndex().get("name", (Object)"I");){
            Assert.assertTrue((String)"can't look up node.", (boolean)nodes.hasNext());
        }
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I", properties={@GraphDescription.PROP(key="name", value="me"), @GraphDescription.PROP(key="bool", value="true", type=GraphDescription.PropType.BOOLEAN)}), @GraphDescription.NODE(name="you", setNameProperty=true)}, relationships={@GraphDescription.REL(start="I", end="you", type="knows", properties={@GraphDescription.PROP(key="name", value="relProp"), @GraphDescription.PROP(key="valid", value="true", type=GraphDescription.PropType.BOOLEAN)})}, autoIndexRelationships=true)
    public void canCreateMoreInvolvedGraphWithPropertiesAndAutoIndex() {
        this.data.get();
        this.verifyIKnowYou("knows", "me");
        try (Transaction ignored = graphdb.beginTx();){
            Assert.assertEquals((Object)true, (Object)((Node)((Map)this.data.get()).get("I")).getProperty("bool"));
            Assert.assertFalse((String)"node autoindex enabled.", (boolean)this.graphdb().index().getNodeAutoIndexer().isEnabled());
            try (IndexHits relationships = this.graphdb().index().getRelationshipAutoIndexer().getAutoIndex().get("name", (Object)"relProp");){
                Assert.assertTrue((String)"can't look up rel.", (boolean)relationships.hasNext());
            }
            Assert.assertTrue((String)"relationship autoindex enabled.", (boolean)this.graphdb().index().getRelationshipAutoIndexer().isEnabled());
        }
    }

    @GraphDescription.Graph(value={"I know you"}, nodes={@GraphDescription.NODE(name="I", properties={@GraphDescription.PROP(key="name", value="me")})})
    private void verifyIKnowYou(String type, String myName) {
        try (Transaction ignored = graphdb.beginTx();){
            Map graph = (Map)this.data.get();
            Assert.assertEquals((String)"Wrong graph size.", (long)2L, (long)graph.size());
            Node iNode = (Node)graph.get("I");
            Assert.assertNotNull((String)"The node 'I' was not defined", (Object)iNode);
            Node you = (Node)graph.get("you");
            Assert.assertNotNull((String)"The node 'you' was not defined", (Object)you);
            Assert.assertEquals((String)"'I' has wrong 'name'.", (Object)myName, (Object)iNode.getProperty("name"));
            Assert.assertEquals((String)"'you' has wrong 'name'.", (Object)"you", (Object)you.getProperty("name"));
            Iterator rels = iNode.getRelationships().iterator();
            Assert.assertTrue((String)"'I' has too few relationships", (boolean)rels.hasNext());
            Relationship rel = (Relationship)rels.next();
            Assert.assertEquals((String)"'I' is not related to 'you'", (Object)you, (Object)rel.getOtherNode(iNode));
            Assert.assertEquals((String)"Wrong relationship type.", (Object)type, (Object)rel.getType().name());
            Assert.assertFalse((String)"'I' has too many relationships", (boolean)rels.hasNext());
            rels = you.getRelationships().iterator();
            Assert.assertTrue((String)"'you' has too few relationships", (boolean)rels.hasNext());
            rel = (Relationship)rels.next();
            Assert.assertEquals((String)"'you' is not related to 'i'", (Object)iNode, (Object)rel.getOtherNode(you));
            Assert.assertEquals((String)"Wrong relationship type.", (Object)type, (Object)rel.getType().name());
            Assert.assertFalse((String)"'you' has too many relationships", (boolean)rels.hasNext());
            Assert.assertEquals((String)"wrong direction", (Object)iNode, (Object)rel.getStartNode());
        }
    }

    @BeforeClass
    public static void startDatabase() {
        graphdb = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().newGraphDatabase();
    }

    @AfterClass
    public static void stopDatabase() {
        if (graphdb != null) {
            graphdb.shutdown();
        }
        graphdb = null;
    }

    public GraphDatabaseService graphdb() {
        return graphdb;
    }
}

