/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Cancelable;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.RepeatRule;
import org.neo4j.test.rule.TestDirectory;

public class PageCacheCountersIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private GraphDatabaseService db;
    private ExecutorService executors;
    private int numberOfWorkers;

    @Before
    public void setUp() {
        this.db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.storeDir());
        this.numberOfWorkers = Runtime.getRuntime().availableProcessors();
        this.executors = Executors.newFixedThreadPool(this.numberOfWorkers);
    }

    @After
    public void tearDown() throws InterruptedException {
        this.executors.shutdown();
        this.executors.awaitTermination(5L, TimeUnit.SECONDS);
        this.db.shutdown();
    }

    @Test(timeout=60000L)
    @RepeatRule.Repeat(times=5)
    public void pageCacheCountersAreSumOfPageCursorCounters() throws Exception {
        ArrayList<NodeCreator> nodeCreators = new ArrayList<NodeCreator>(this.numberOfWorkers);
        ArrayList<Future> nodeCreatorFutures = new ArrayList<Future>(this.numberOfWorkers);
        PageCacheTracer pageCacheTracer = this.getPageCacheTracer(this.db);
        long initialPins = pageCacheTracer.pins();
        long initialHits = pageCacheTracer.hits();
        long initialUnpins = pageCacheTracer.unpins();
        long initialBytesRead = pageCacheTracer.bytesRead();
        long initialBytesWritten = pageCacheTracer.bytesWritten();
        long initialEvictions = pageCacheTracer.evictions();
        long initialFaults = pageCacheTracer.faults();
        long initialFlushes = pageCacheTracer.flushes();
        this.startNodeCreators(nodeCreators, nodeCreatorFutures);
        while (pageCacheTracer.pins() == 0L || pageCacheTracer.faults() == 0L || pageCacheTracer.unpins() == 0L) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        this.stopNodeCreators(nodeCreators, nodeCreatorFutures);
        Assert.assertThat((String)"Number of pins events in page cache tracer should equal to the sum of pin events in page cursor tracers.", (Object)pageCacheTracer.pins(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.sumCounters(nodeCreators, NodeCreator::getPins, initialPins))));
        Assert.assertThat((String)"Number of unpins events in page cache tracer should equal to the sum of unpin events in page cursor tracers.", (Object)pageCacheTracer.unpins(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.sumCounters(nodeCreators, NodeCreator::getUnpins, initialUnpins))));
        Assert.assertThat((String)"Number of initialBytesRead in page cache tracer should equal to the sum of initialBytesRead in page cursor tracers.", (Object)pageCacheTracer.bytesRead(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.sumCounters(nodeCreators, NodeCreator::getBytesRead, initialBytesRead))));
        Assert.assertThat((String)"Number of bytesWritten in page cache tracer should equal to the sum of bytesWritten in page cursor tracers.", (Object)pageCacheTracer.bytesWritten(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.sumCounters(nodeCreators, NodeCreator::getBytesWritten, initialBytesWritten))));
        Assert.assertThat((String)"Number of evictions in page cache tracer should equal to the sum of evictions in page cursor tracers.", (Object)pageCacheTracer.evictions(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.sumCounters(nodeCreators, NodeCreator::getEvictions, initialEvictions))));
        Assert.assertThat((String)"Number of faults in page cache tracer should equal to the sum of faults in page cursor tracers.", (Object)pageCacheTracer.faults(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.sumCounters(nodeCreators, NodeCreator::getFaults, initialFaults))));
        Assert.assertThat((String)"Number of flushes in page cache tracer should equal to the sum of flushes in page cursor tracers.", (Object)pageCacheTracer.flushes(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.sumCounters(nodeCreators, NodeCreator::getFlushes, initialFlushes))));
        Assert.assertThat((String)"Number of hits in page cache tracer should equal to the sum of hits in page cursor tracers.", (Object)pageCacheTracer.hits(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.sumCounters(nodeCreators, NodeCreator::getHits, initialHits))));
    }

    private void stopNodeCreators(List<NodeCreator> nodeCreators, List<Future> nodeCreatorFutures) throws InterruptedException, ExecutionException {
        nodeCreators.forEach(NodeCreator::cancel);
        for (Future creatorFuture : nodeCreatorFutures) {
            creatorFuture.get();
        }
    }

    private void startNodeCreators(List<NodeCreator> nodeCreators, List<Future> nodeCreatorFutures) {
        for (int i = 0; i < this.numberOfWorkers; ++i) {
            NodeCreator nodeCreator = new NodeCreator(this.db);
            nodeCreators.add(nodeCreator);
            nodeCreatorFutures.add(this.executors.submit(nodeCreator));
        }
    }

    private long sumCounters(List<NodeCreator> nodeCreators, ToLongFunction<NodeCreator> mapper, long initialValue) {
        return nodeCreators.stream().mapToLong(mapper).sum() + initialValue;
    }

    private PageCacheTracer getPageCacheTracer(GraphDatabaseService db) {
        Tracers tracers = (Tracers)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(Tracers.class);
        return tracers.pageCacheTracer;
    }

    private class NodeCreator
    implements Runnable,
    Cancelable {
        private volatile boolean canceled;
        private final GraphDatabaseService db;
        private long pins;
        private long unpins;
        private long hits;
        private long bytesRead;
        private long bytesWritten;
        private long evictions;
        private long faults;
        private long flushes;

        NodeCreator(GraphDatabaseService db) {
            this.db = db;
        }

        @Override
        public void run() {
            ThreadLocalRandom localRandom = ThreadLocalRandom.current();
            while (!this.canceled) {
                Transaction transaction = this.db.beginTx();
                Throwable throwable = null;
                try {
                    KernelStatement kernelStatement = this.getKernelStatement((GraphDatabaseAPI)this.db);
                    Throwable throwable2 = null;
                    try {
                        PageCursorTracer pageCursorCounters = kernelStatement.getPageCursorTracer();
                        Node node = this.db.createNode();
                        node.setProperty("name", (Object)RandomStringUtils.random((int)localRandom.nextInt(100)));
                        node.setProperty("surname", (Object)RandomStringUtils.random((int)localRandom.nextInt(100)));
                        node.setProperty("age", (Object)localRandom.nextInt(100));
                        transaction.success();
                        this.storeCounters((PageCursorCounters)pageCursorCounters);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (kernelStatement == null) continue;
                        if (throwable2 != null) {
                            try {
                                kernelStatement.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        kernelStatement.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (transaction == null) continue;
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    transaction.close();
                }
            }
        }

        private void storeCounters(PageCursorCounters pageCursorCounters) {
            Objects.requireNonNull(pageCursorCounters);
            this.pins += pageCursorCounters.pins();
            this.unpins += pageCursorCounters.unpins();
            this.hits += pageCursorCounters.hits();
            this.bytesRead += pageCursorCounters.bytesRead();
            this.bytesWritten += pageCursorCounters.bytesWritten();
            this.evictions += pageCursorCounters.evictions();
            this.faults += pageCursorCounters.faults();
            this.flushes += pageCursorCounters.flushes();
        }

        public void cancel() {
            this.canceled = true;
        }

        long getPins() {
            return this.pins;
        }

        long getUnpins() {
            return this.unpins;
        }

        public long getHits() {
            return this.hits;
        }

        long getBytesRead() {
            return this.bytesRead;
        }

        long getBytesWritten() {
            return this.bytesWritten;
        }

        long getEvictions() {
            return this.evictions;
        }

        long getFaults() {
            return this.faults;
        }

        long getFlushes() {
            return this.flushes;
        }

        private KernelStatement getKernelStatement(GraphDatabaseAPI db) {
            ThreadToStatementContextBridge statementBridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            return (KernelStatement)statementBridge.get();
        }
    }
}

