/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexValueTestUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class BatchInsertIndexTest {
    private final GraphDatabaseSettings.SchemaIndex schemaIndex;
    private DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private TestDirectory storeDir = TestDirectory.testDirectory();
    private PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.storeDir).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);

    @Parameterized.Parameters(name="{0}")
    public static GraphDatabaseSettings.SchemaIndex[] data() {
        return GraphDatabaseSettings.SchemaIndex.values();
    }

    public BatchInsertIndexTest(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.schemaIndex = schemaIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void batchInserterShouldUseConfiguredIndexProvider() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_schema_provider.name(), this.schemaIndex.providerName()}));
        BatchInserter inserter = this.newBatchInserter(config);
        inserter.createDeferredSchemaIndex((Label)TestLabels.LABEL_ONE).on("key").create();
        inserter.shutdown();
        GraphDatabaseService db = this.graphDatabaseService(config);
        this.awaitIndexesOnline(db);
        try (Transaction tx = db.beginTx();){
            DependencyResolver dependencyResolver = ((GraphDatabaseAPI)db).getDependencyResolver();
            ThreadToStatementContextBridge threadToStatementContextBridge = (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
            KernelTransaction kernelTransaction = threadToStatementContextBridge.getKernelTransactionBoundToThisThread(true);
            TokenRead tokenRead = kernelTransaction.tokenRead();
            SchemaRead schemaRead = kernelTransaction.schemaRead();
            int labelId = tokenRead.nodeLabel(TestLabels.LABEL_ONE.name());
            int propertyId = tokenRead.propertyKey("key");
            IndexReference index = schemaRead.index(labelId, new int[]{propertyId});
            Assert.assertTrue((String)BatchInsertIndexTest.unexpectedIndexProviderMessage(index), (boolean)this.schemaIndex.providerName().contains(index.providerKey()));
            Assert.assertTrue((String)BatchInsertIndexTest.unexpectedIndexProviderMessage(index), (boolean)this.schemaIndex.providerName().contains(index.providerVersion()));
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPopulateIndexWithUniquePointsThatCollideOnSpaceFillingCurve() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_schema_provider.name(), this.schemaIndex.providerName()}));
        BatchInserter inserter = this.newBatchInserter(config);
        Pair collidingPoints = SpatialIndexValueTestUtil.pointsWithSameValueOnSpaceFillingCurve((Config)config);
        inserter.createNode(MapUtil.map((Object[])new Object[]{"prop", collidingPoints.first()}), new Label[]{TestLabels.LABEL_ONE});
        inserter.createNode(MapUtil.map((Object[])new Object[]{"prop", collidingPoints.other()}), new Label[]{TestLabels.LABEL_ONE});
        inserter.createDeferredConstraint((Label)TestLabels.LABEL_ONE).assertPropertyIsUnique("prop").create();
        inserter.shutdown();
        GraphDatabaseService db = this.graphDatabaseService(config);
        try {
            this.awaitIndexesOnline(db);
            try (Transaction tx = db.beginTx();){
                this.assertSingleCorrectHit(db, (PointValue)collidingPoints.first());
                this.assertSingleCorrectHit(db, (PointValue)collidingPoints.other());
                tx.success();
            }
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowWhenPopulatingWithNonUniquePoints() throws Exception {
        Config config = Config.defaults((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_schema_provider.name(), this.schemaIndex.providerName()}));
        BatchInserter inserter = this.newBatchInserter(config);
        PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        inserter.createNode(MapUtil.map((Object[])new Object[]{"prop", point}), new Label[]{TestLabels.LABEL_ONE});
        inserter.createNode(MapUtil.map((Object[])new Object[]{"prop", point}), new Label[]{TestLabels.LABEL_ONE});
        inserter.createDeferredConstraint((Label)TestLabels.LABEL_ONE).assertPropertyIsUnique("prop").create();
        inserter.shutdown();
        GraphDatabaseService db = this.graphDatabaseService(config);
        try (Transaction tx = db.beginTx();){
            Iterator indexes = db.schema().getIndexes().iterator();
            Assert.assertTrue((boolean)indexes.hasNext());
            IndexDefinition index = (IndexDefinition)indexes.next();
            Schema.IndexState indexState = db.schema().getIndexState(index);
            Assert.assertEquals((Object)Schema.IndexState.FAILED, (Object)indexState);
            Assert.assertFalse((boolean)indexes.hasNext());
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private void assertSingleCorrectHit(GraphDatabaseService db, PointValue point) {
        ResourceIterator nodes = db.findNodes((Label)TestLabels.LABEL_ONE, "prop", (Object)point);
        Assert.assertTrue((boolean)nodes.hasNext());
        Node node = (Node)nodes.next();
        Object prop = node.getProperty("prop");
        Assert.assertEquals((Object)point, (Object)prop);
        Assert.assertFalse((boolean)nodes.hasNext());
    }

    private BatchInserter newBatchInserter(Config config) throws Exception {
        return BatchInserters.inserter((File)this.storeDir.databaseDir(), (FileSystemAbstraction)this.fileSystemRule.get(), (Map)config.getRaw());
    }

    private GraphDatabaseService graphDatabaseService(Config config) {
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setFileSystem(this.fileSystemRule.get());
        return factory.newImpermanentDatabaseBuilder(this.storeDir.databaseDir()).setConfig(config.getRaw()).newGraphDatabase();
    }

    private void awaitIndexesOnline(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
    }

    private static String unexpectedIndexProviderMessage(IndexReference index) {
        return "Unexpected provider: key=" + index.providerKey() + ", version=" + index.providerVersion();
    }
}

