/*
 * Decompiled with CFR 0.152.
 */
package recovery;

import java.io.File;
import java.io.IOException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.Barrier;
import org.neo4j.test.Race;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;

public class RecoveryCleanupIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private GraphDatabaseService db;
    private File storeDir;
    private final TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
    private final ExecutorService executor = Executors.newFixedThreadPool(2);
    private final Label label = Label.label((String)"label");
    private final String propKey = "propKey";
    private Map<Setting, String> testSpecificConfig = new HashMap<Setting, String>();

    @Before
    public void setup() {
        this.storeDir = this.testDirectory.storeDir();
        this.testSpecificConfig.clear();
    }

    @After
    public void tearDown() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void recoveryCleanupShouldBlockRecoveryWritingToCleanedIndexes() throws Throwable {
        AtomicReference error = new AtomicReference();
        try {
            this.dirtyDatabase();
            Barrier.Control recoveryCompleteBarrier = new Barrier.Control();
            RecoveryBarrierMonitor recoveryBarrierMonitor = new RecoveryBarrierMonitor(recoveryCompleteBarrier);
            this.setMonitor((Object)recoveryBarrierMonitor);
            Future<?> recovery = this.executor.submit(() -> {
                this.db = this.startDatabase();
            });
            recoveryCompleteBarrier.awaitUninterruptibly();
            this.shouldWait(recovery);
            recoveryCompleteBarrier.release();
            recovery.get();
            this.db.shutdown();
        }
        finally {
            Throwable throwable = (Throwable)error.get();
            if (throwable != null) {
                throw throwable;
            }
        }
    }

    @Test
    public void scanStoreMustLogCrashPointerCleanupDuringRecovery() throws Exception {
        this.dirtyDatabase();
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        this.factory.setUserLogProvider((LogProvider)logProvider);
        this.factory.setInternalLogProvider((LogProvider)logProvider);
        this.startDatabase().shutdown();
        logProvider.rawMessageMatcher().assertContains("Label index cleanup job registered");
        logProvider.rawMessageMatcher().assertContains("Label index cleanup job started");
        logProvider.rawMessageMatcher().assertContains(Matchers.stringContainsInOrder((Iterable)Iterables.asIterable((Object[])new String[]{"Label index cleanup job finished", "Number of pages visited", "Number of cleaned crashed pointers", "Time spent"})));
        logProvider.rawMessageMatcher().assertContains("Label index cleanup job closed");
    }

    @Test
    public void nativeIndexFusion10MustLogCrashPointerCleanupDuringRecovery() throws Exception {
        this.nativeIndexMustLogCrashPointerCleanupDuringRecovery(GraphDatabaseSettings.SchemaIndex.NATIVE10, "native", "spatial", "temporal");
    }

    @Test
    public void nativeIndexFusion20MustLogCrashPointerCleanupDuringRecovery() throws Exception {
        this.nativeIndexMustLogCrashPointerCleanupDuringRecovery(GraphDatabaseSettings.SchemaIndex.NATIVE20, "string", "native", "spatial", "temporal");
    }

    @Test
    public void nativeIndexBTreeMustLogCrashPointerCleanupDuringRecovery() throws Exception {
        this.nativeIndexMustLogCrashPointerCleanupDuringRecovery(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10, "index");
    }

    private void nativeIndexMustLogCrashPointerCleanupDuringRecovery(GraphDatabaseSettings.SchemaIndex setting, String ... subTypes) throws Exception {
        this.setTestConfig(GraphDatabaseSettings.default_schema_provider, setting.providerName());
        this.dirtyDatabase();
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        this.factory.setInternalLogProvider((LogProvider)logProvider);
        this.startDatabase().shutdown();
        ArrayList<Matcher<String>> matchers = new ArrayList<Matcher<String>>();
        for (String subType : subTypes) {
            matchers.add(this.indexRecoveryLogMatcher("Schema index cleanup job registered", subType));
            matchers.add(this.indexRecoveryLogMatcher("Schema index cleanup job started", subType));
            matchers.add(this.indexRecoveryFinishedLogMatcher(subType));
            matchers.add(this.indexRecoveryLogMatcher("Schema index cleanup job closed", subType));
        }
        AssertableLogProvider.MessageMatcher messageMatcher = logProvider.rawMessageMatcher();
        matchers.forEach(arg_0 -> ((AssertableLogProvider.MessageMatcher)messageMatcher).assertContainsSingle(arg_0));
    }

    private Matcher<String> indexRecoveryLogMatcher(String logMessage, String subIndexProviderKey) {
        return Matchers.stringContainsInOrder((Iterable)Iterables.asIterable((Object[])new String[]{logMessage, "descriptor", "indexFile=", File.separator + subIndexProviderKey}));
    }

    private Matcher<String> indexRecoveryFinishedLogMatcher(String subIndexProviderKey) {
        return Matchers.stringContainsInOrder((Iterable)Iterables.asIterable((Object[])new String[]{"Schema index cleanup job finished", "descriptor", "indexFile=", File.separator + subIndexProviderKey, "Number of pages visited", "Number of cleaned crashed pointers", "Time spent"}));
    }

    private void dirtyDatabase() throws IOException {
        this.db = this.startDatabase();
        DatabaseHealth databaseHealth = this.databaseHealth(this.db);
        this.index(this.db);
        this.someData(this.db);
        this.checkpoint(this.db);
        this.someData(this.db);
        databaseHealth.panic(new Throwable("Trigger recovery on next startup"));
        this.db.shutdown();
        this.db = null;
    }

    private void setTestConfig(Setting<?> setting, String value) {
        this.testSpecificConfig.put(setting, value);
    }

    private void setMonitor(Object monitor) {
        Monitors monitors = new Monitors();
        monitors.addMonitorListener(monitor, new String[0]);
        this.factory.setMonitors(monitors);
    }

    private void index(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(this.label).on("propKey").create();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void reportError(Race.ThrowingRunnable checkpoint, AtomicReference<Throwable> error) {
        try {
            checkpoint.run();
        }
        catch (Throwable t) {
            error.compareAndSet(null, t);
        }
    }

    private void checkpoint(GraphDatabaseService db) throws IOException {
        CheckPointer checkPointer = this.checkPointer(db);
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private void someData(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{this.label}).setProperty("propKey", (Object)1);
            db.createNode(new Label[]{this.label}).setProperty("propKey", (Object)"string");
            db.createNode(new Label[]{this.label}).setProperty("propKey", (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{0.5, 0.5}));
            db.createNode(new Label[]{this.label}).setProperty("propKey", (Object)LocalTime.of(0, 0));
            tx.success();
        }
    }

    private void shouldWait(Future<?> future) throws InterruptedException, ExecutionException {
        try {
            future.get(200L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected timeout");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private GraphDatabaseService startDatabase() {
        GraphDatabaseBuilder builder = this.factory.newEmbeddedDatabaseBuilder(this.storeDir);
        this.testSpecificConfig.forEach((arg_0, arg_1) -> ((GraphDatabaseBuilder)builder).setConfig(arg_0, arg_1));
        return builder.newGraphDatabase();
    }

    private DatabaseHealth databaseHealth(GraphDatabaseService db) {
        return (DatabaseHealth)this.dependencyResolver(db).resolveDependency(DatabaseHealth.class);
    }

    private CheckPointer checkPointer(GraphDatabaseService db) {
        DependencyResolver dependencyResolver = this.dependencyResolver(db);
        return (CheckPointer)((NeoStoreDataSource)dependencyResolver.resolveDependency(NeoStoreDataSource.class)).getDependencyResolver().resolveDependency(CheckPointer.class);
    }

    private DependencyResolver dependencyResolver(GraphDatabaseService db) {
        return ((GraphDatabaseAPI)db).getDependencyResolver();
    }

    private class RecoveryBarrierMonitor
    extends LabelScanStore.Monitor.Adaptor {
        private final Barrier.Control barrier;

        RecoveryBarrierMonitor(Barrier.Control barrier) {
            this.barrier = barrier;
        }

        public void recoveryCleanupFinished(long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
            this.barrier.reached();
        }
    }
}

