/*
 * Decompiled with CFR 0.152.
 */
package visibility;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.RepeatRule;

public class TestPropertyReadOnNewEntityBeforeLockRelease {
    private static final String INDEX_NAME = "nodes";
    private static final int MAX_READER_DELAY_MS = 10;
    @ClassRule
    public static final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final RepeatRule repeat = new RepeatRule();

    @BeforeClass
    public static void initializeIndex() {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            db.index().forNodes(INDEX_NAME).add((PropertyContainer)node, "foo", (Object)"bar");
            tx.success();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldBeAbleToReadPropertiesFromNewNodeReturnedFromIndex() throws Exception {
        Future<?> readResult;
        Future<?> writeResult;
        String propertyKey = UUID.randomUUID().toString();
        String propertyValue = UUID.randomUUID().toString();
        AtomicBoolean start = new AtomicBoolean(false);
        int readerDelay = ThreadLocalRandom.current().nextInt(10);
        Writer writer = new Writer((GraphDatabaseService)db, propertyKey, propertyValue, start);
        Reader reader = new Reader((GraphDatabaseService)db, propertyKey, propertyValue, start, readerDelay);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            writeResult = executor.submit(writer);
            readResult = executor.submit(reader);
            start.set(true);
        }
        finally {
            executor.shutdown();
            executor.awaitTermination(20L, TimeUnit.SECONDS);
        }
        Assert.assertNull(writeResult.get());
        Assert.assertNull(readResult.get());
    }

    private static class Reader
    implements Runnable {
        final GraphDatabaseService db;
        final String propertyKey;
        final String propertyValue;
        final AtomicBoolean start;
        private final int delay;

        Reader(GraphDatabaseService db, String propertyKey, String propertyValue, AtomicBoolean start, int delay) {
            this.db = db;
            this.propertyKey = propertyKey;
            this.propertyValue = propertyValue;
            this.start = start;
            this.delay = delay;
        }

        @Override
        public void run() {
            while (!this.start.get()) {
            }
            this.sleep();
            try (Transaction tx = this.db.beginTx();){
                Node node = (Node)this.db.index().forNodes(TestPropertyReadOnNewEntityBeforeLockRelease.INDEX_NAME).get(this.propertyKey, (Object)this.propertyValue).getSingle();
                if (node != null) {
                    Assert.assertEquals((Object)this.propertyValue, (Object)node.getProperty(this.propertyKey));
                }
                tx.success();
            }
        }

        private void sleep() {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private static class Writer
    implements Runnable {
        final GraphDatabaseService db;
        final String propertyKey;
        final String propertyValue;
        final AtomicBoolean start;

        Writer(GraphDatabaseService db, String propertyKey, String propertyValue, AtomicBoolean start) {
            this.db = db;
            this.propertyKey = propertyKey;
            this.propertyValue = propertyValue;
            this.start = start;
        }

        @Override
        public void run() {
            while (!this.start.get()) {
            }
            try (Transaction tx = this.db.beginTx();){
                Node node = this.db.createNode();
                node.setProperty(this.propertyKey, (Object)this.propertyValue);
                this.db.index().forNodes(TestPropertyReadOnNewEntityBeforeLockRelease.INDEX_NAME).add((PropertyContainer)node, this.propertyKey, (Object)this.propertyValue);
                tx.success();
            }
        }
    }
}

