/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Format;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.internal.KernelDiagnostics;
import org.neo4j.kernel.internal.NativeIndexFileFilter;
import org.neo4j.logging.Logger;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class KernelDiagnosticsIT {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void shouldIncludeNativeIndexFilesInTotalMappedSize() {
        int i = 0;
        for (GraphDatabaseSettings.SchemaIndex schemaIndex : GraphDatabaseSettings.SchemaIndex.values()) {
            File dbDir = new File(this.directory.databaseDir(), String.valueOf(i++));
            this.createIndexInIsolatedDbInstance(dbDir, schemaIndex);
            KernelDiagnostics.StoreFiles files = new KernelDiagnostics.StoreFiles(DatabaseLayout.of((File)dbDir));
            SizeCapture capture = new SizeCapture();
            files.dump((Logger)capture);
            Assert.assertNotNull((Object)capture.size);
            long expected = this.manuallyCountTotalMappedFileSize(dbDir);
            Assert.assertEquals((Object)Format.bytes((long)expected), (Object)capture.size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexInIsolatedDbInstance(File storeDir, GraphDatabaseSettings.SchemaIndex index) {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.default_schema_provider, index.providerName()).newGraphDatabase();
        try {
            Label label = Label.label((String)("Label-" + index.providerName()));
            String key = "key";
            try (Transaction tx = db.beginTx();){
                for (int i = 0; i < 100; ++i) {
                    db.createNode(new Label[]{label}).setProperty(key, (Object)i);
                }
                tx.success();
            }
            tx = db.beginTx();
            var7_7 = null;
            try {
                db.schema().indexFor(label).on(key).create();
                tx.success();
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var7_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            tx = db.beginTx();
            var7_7 = null;
            try {
                db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                tx.success();
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var7_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            db.shutdown();
        }
    }

    private long manuallyCountTotalMappedFileSize(File dbDir) {
        MutableLong result = new MutableLong();
        NativeIndexFileFilter nativeIndexFilter = new NativeIndexFileFilter(dbDir);
        this.manuallyCountTotalMappedFileSize(dbDir, result, nativeIndexFilter);
        return result.getValue();
    }

    private void manuallyCountTotalMappedFileSize(File dir, MutableLong result, NativeIndexFileFilter nativeIndexFilter) {
        Set storeFiles = Stream.of(StoreType.values()).filter(StoreType::isRecordStore).map(type -> type.getDatabaseFile().getName()).collect(Collectors.toSet());
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.manuallyCountTotalMappedFileSize(file, result, nativeIndexFilter);
                continue;
            }
            if (!storeFiles.contains(file.getName()) && !file.getName().equals(DatabaseFile.LABEL_SCAN_STORE.getName()) && !nativeIndexFilter.accept(file)) continue;
            result.add(file.length());
        }
    }

    private class SizeCapture
    implements Logger {
        private String size;

        private SizeCapture() {
        }

        public void log(@Nonnull String message) {
            if (message.contains("Total size of mapped files")) {
                int beginPos = message.lastIndexOf(": ");
                Assert.assertTrue((beginPos != -1 ? 1 : 0) != 0);
                this.size = message.substring(beginPos + 2);
            }
        }

        public void log(@Nonnull String message, @Nonnull Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        public void log(@Nonnull String format, Object ... arguments) {
            this.log(String.format(format, arguments));
        }

        public void bulk(@Nonnull Consumer<Logger> consumer) {
            throw new UnsupportedOperationException();
        }
    }
}

