/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Barrier;
import org.neo4j.test.NamedFunction;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.concurrent.ThreadingRule;

public class RelationshipCountsTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    private Supplier<KernelTransaction> ktxSupplier;

    @Before
    public void exposeGuts() {
        this.ktxSupplier = () -> ((ThreadToStatementContextBridge)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
    }

    @Test
    public void shouldReportNumberOfRelationshipsInAnEmptyGraph() {
        long relationshipCount = this.numberOfRelationships();
        Assert.assertEquals((long)0L, (long)relationshipCount);
    }

    @Test
    public void shouldReportTotalNumberOfRelationships() {
        long during;
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        long before = this.numberOfRelationships();
        try (Transaction tx = graphDb.beginTx();){
            Node node = graphDb.createNode();
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            during = this.countsForRelationship(null, null, null);
            tx.success();
        }
        long after = this.numberOfRelationships();
        Assert.assertEquals((long)0L, (long)before);
        Assert.assertEquals((long)3L, (long)during);
        Assert.assertEquals((long)3L, (long)after);
    }

    @Test
    public void shouldAccountForDeletedRelationships() {
        long during;
        Relationship rel;
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            Node node = graphDb.createNode();
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            rel = node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        long before = this.numberOfRelationships();
        try (Transaction tx = graphDb.beginTx();){
            rel.delete();
            during = this.countsForRelationship(null, null, null);
            tx.success();
        }
        long after = this.numberOfRelationships();
        Assert.assertEquals((long)3L, (long)before);
        Assert.assertEquals((long)2L, (long)during);
        Assert.assertEquals((long)2L, (long)after);
    }

    @Test
    public void shouldNotCountRelationshipsCreatedInOtherTransaction() throws Exception {
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        final Barrier.Control barrier = new Barrier.Control();
        long before = this.numberOfRelationships();
        Future tx = this.threading.execute((ThrowingFunction)new NamedFunction<GraphDatabaseService, Long>("create-relationships"){

            public Long apply(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    Node node = graphDb.createNode();
                    node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
                    node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
                    long whatThisThreadSees = RelationshipCountsTest.this.countsForRelationship(null, null, null);
                    barrier.reached();
                    tx.success();
                    Long l = whatThisThreadSees;
                    return l;
                }
            }
        }, (Object)graphDb);
        barrier.await();
        long during = this.numberOfRelationships();
        barrier.release();
        long whatOtherThreadSees = (Long)tx.get();
        long after = this.numberOfRelationships();
        Assert.assertEquals((long)0L, (long)before);
        Assert.assertEquals((long)0L, (long)during);
        Assert.assertEquals((long)2L, (long)after);
        Assert.assertEquals((long)after, (long)whatOtherThreadSees);
    }

    @Test
    public void shouldNotCountRelationshipsDeletedInOtherTransaction() throws Exception {
        Relationship rel;
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            Node node = graphDb.createNode();
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            rel = node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        final Barrier.Control barrier = new Barrier.Control();
        long before = this.numberOfRelationships();
        Future tx = this.threading.execute((ThrowingFunction)new NamedFunction<GraphDatabaseService, Long>("create-relationships"){

            public Long apply(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    rel.delete();
                    long whatThisThreadSees = RelationshipCountsTest.this.countsForRelationship(null, null, null);
                    barrier.reached();
                    tx.success();
                    Long l = whatThisThreadSees;
                    return l;
                }
            }
        }, (Object)graphDb);
        barrier.await();
        long during = this.numberOfRelationships();
        barrier.release();
        long whatOtherThreadSees = (Long)tx.get();
        long after = this.numberOfRelationships();
        Assert.assertEquals((long)3L, (long)before);
        Assert.assertEquals((long)3L, (long)during);
        Assert.assertEquals((long)2L, (long)after);
        Assert.assertEquals((long)after, (long)whatOtherThreadSees);
    }

    @Test
    public void shouldCountRelationshipsByType() {
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"FOO"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"FOO"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BAR"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BAR"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BAR"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BAZ"));
            tx.success();
        }
        long total = this.numberOfRelationships();
        long foo = this.numberOfRelationships(RelationshipType.withName((String)"FOO"));
        long bar = this.numberOfRelationships(RelationshipType.withName((String)"BAR"));
        long baz = this.numberOfRelationships(RelationshipType.withName((String)"BAZ"));
        long qux = this.numberOfRelationships(RelationshipType.withName((String)"QUX"));
        Assert.assertEquals((long)2L, (long)foo);
        Assert.assertEquals((long)3L, (long)bar);
        Assert.assertEquals((long)1L, (long)baz);
        Assert.assertEquals((long)0L, (long)qux);
        Assert.assertEquals((long)6L, (long)total);
    }

    @Test
    public void shouldUpdateRelationshipWithLabelCountsWhenDeletingNodeWithRelationship() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[]{Label.label((String)"Foo")});
            Node bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"BAZ"));
            tx.success();
        }
        long before = this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BAZ"), null);
        try (Transaction tx = this.db.beginTx();){
            for (Relationship relationship : foo.getRelationships()) {
                relationship.delete();
            }
            foo.delete();
            tx.success();
        }
        long after = this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BAZ"), null);
        Assert.assertEquals((long)(before - 1L), (long)after);
    }

    @Test
    public void shouldUpdateRelationshipWithLabelCountsWhenDeletingNodesWithRelationships() {
        int i;
        Object foo;
        int i2;
        int numberOfNodes = 2;
        Node nodes = new Node[numberOfNodes];
        try (Transaction tx = this.db.beginTx();){
            for (i2 = 0; i2 < numberOfNodes; ++i2) {
                foo = this.db.createNode(new Label[]{Label.label((String)("Foo" + i2))});
                foo.addLabel(Label.label((String)"Common"));
                Node bar = this.db.createNode(new Label[]{Label.label((String)("Bar" + i2))});
                foo.createRelationshipTo(bar, RelationshipType.withName((String)("BAZ" + i2)));
                nodes[i2] = foo;
            }
            tx.success();
        }
        long[] beforeCommon = new long[numberOfNodes];
        long[] before = new long[numberOfNodes];
        for (i2 = 0; i2 < numberOfNodes; ++i2) {
            beforeCommon[i2] = this.numberOfRelationshipsMatching(Label.label((String)"Common"), RelationshipType.withName((String)("BAZ" + i2)), null);
            before[i2] = this.numberOfRelationshipsMatching(Label.label((String)("Foo" + i2)), RelationshipType.withName((String)("BAZ" + i2)), null);
        }
        Transaction tx = this.db.beginTx();
        foo = null;
        try {
            for (Node node : nodes) {
                for (Relationship relationship : node.getRelationships()) {
                    relationship.delete();
                }
                node.delete();
            }
            tx.success();
        }
        catch (Throwable bar) {
            foo = bar;
            throw bar;
        }
        finally {
            if (tx != null) {
                if (foo != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable bar) {
                        ((Throwable)foo).addSuppressed(bar);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long[] afterCommon = new long[numberOfNodes];
        long[] after = new long[numberOfNodes];
        for (i = 0; i < numberOfNodes; ++i) {
            afterCommon[i] = this.numberOfRelationshipsMatching(Label.label((String)"Common"), RelationshipType.withName((String)("BAZ" + i)), null);
            after[i] = this.numberOfRelationshipsMatching(Label.label((String)("Foo" + i)), RelationshipType.withName((String)("BAZ" + i)), null);
        }
        for (i = 0; i < numberOfNodes; ++i) {
            Assert.assertEquals((long)(beforeCommon[i] - 1L), (long)afterCommon[i]);
            Assert.assertEquals((long)(before[i] - 1L), (long)after[i]);
        }
    }

    @Test
    public void shouldUpdateRelationshipWithLabelCountsWhenRemovingLabelAndDeletingRelationship() {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(new Label[]{Label.label((String)"Foo")});
            Node bar = this.db.createNode(new Label[]{Label.label((String)"Bar")});
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"BAZ"));
            tx.success();
        }
        long before = this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BAZ"), null);
        try (Transaction tx = this.db.beginTx();){
            for (Relationship relationship : foo.getRelationships()) {
                relationship.delete();
            }
            foo.removeLabel(Label.label((String)"Foo"));
            tx.success();
        }
        long after = this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BAZ"), null);
        Assert.assertEquals((long)(before - 1L), (long)after);
    }

    private long numberOfRelationships(RelationshipType type) {
        return this.numberOfRelationshipsMatching(null, type, null);
    }

    private long numberOfRelationships() {
        return this.numberOfRelationshipsMatching(null, null, null);
    }

    private long numberOfRelationshipsMatching(Label lhs, RelationshipType type, Label rhs) {
        try (Transaction tx = this.db.getGraphDatabaseAPI().beginTx();){
            long nodeCount = this.countsForRelationship(lhs, type, rhs);
            tx.success();
            long l = nodeCount;
            return l;
        }
    }

    private long countsForRelationship(Label start, RelationshipType type, Label end) {
        KernelTransaction ktx = this.ktxSupplier.get();
        try (Statement ignore = ktx.acquireStatement();){
            int endId;
            int typeId;
            int startId;
            TokenRead tokenRead = ktx.tokenRead();
            if (start == null) {
                startId = -1;
            } else {
                startId = tokenRead.nodeLabel(start.name());
                if (-1 == startId) {
                    long l = 0L;
                    return l;
                }
            }
            if (type == null) {
                typeId = -1;
            } else {
                typeId = tokenRead.relationshipType(type.name());
                if (-1 == typeId) {
                    long l = 0L;
                    return l;
                }
            }
            if (end == null) {
                endId = -1;
            } else {
                endId = tokenRead.nodeLabel(end.name());
                if (-1 == endId) {
                    long l = 0L;
                    return l;
                }
            }
            long l = ktx.dataRead().countsForRelationship(startId, typeId, endId);
            return l;
        }
    }
}

