/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.helpers.TransactionTemplate;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class TransactionTemplateTest {
    @Rule
    public EmbeddedDatabaseRule databaseRule = new EmbeddedDatabaseRule();
    @Rule
    public final ExpectedException expected = ExpectedException.none();
    private TransactionTemplate template;
    private CountingMonitor monitor;

    @Before
    public void setUp() {
        this.monitor = new CountingMonitor();
        this.template = new TransactionTemplate().with((GraphDatabaseService)this.databaseRule.getGraphDatabaseAPI()).monitor((TransactionTemplate.Monitor)this.monitor).retries(5).backoff(3L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void shouldForceUserToCallWith() {
        this.expected.expectCause(CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class), (Matcher)Matchers.hasProperty((String)"message", (Matcher)CoreMatchers.is((Object)"You need to call 'with(GraphDatabaseService)' on the template in order to use it"))));
        TransactionTemplate transactionTemplate = new TransactionTemplate();
        transactionTemplate.execute(transaction -> null);
    }

    @Test
    public void validateGraphDatabaseService() {
        this.expected.expect(NullPointerException.class);
        this.template.with(null);
    }

    @Test
    public void validateRetires() {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Number of retries must be greater than or equal to 0");
        this.template.retries(-1);
    }

    @Test
    public void validateBackoff() {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Backoff time must be a positive number");
        this.template.backoff(-10L, TimeUnit.SECONDS);
    }

    @Test
    public void validateMonitor() {
        this.expected.expect(NullPointerException.class);
        this.template.monitor(null);
    }

    @Test
    public void validateRetryOn() {
        this.expected.expect(NullPointerException.class);
        this.template.retryOn(null);
    }

    @Test
    public void shouldRetryOnError() {
        IllegalArgumentException ex = new IllegalArgumentException();
        this.template.execute((Consumer)new FailingRetryConsumer(3, ex));
        Assert.assertThat((Object)this.monitor.numRetry, (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat(this.monitor.failures, (Matcher)Matchers.contains((Object[])new Throwable[]{ex, ex, ex}));
        Assert.assertThat(this.monitor.fails, (Matcher)Matchers.empty());
    }

    @Test
    public void shouldFailIfAllRetiresFail() {
        IllegalArgumentException ex = new IllegalArgumentException();
        try {
            this.template.execute((Consumer)new FailingRetryConsumer(10, ex));
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.monitor.numRetry, (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat(this.monitor.failures, (Matcher)Matchers.contains((Object[])new Throwable[]{ex, ex, ex, ex, ex, ex}));
        Assert.assertThat(this.monitor.fails, (Matcher)Matchers.contains((Object[])new Throwable[]{ex}));
    }

    @Test
    public void defaultExceptionsForExit() {
        Error error = new Error();
        TransactionTerminatedException terminatedException = new TransactionTerminatedException((Status)Status.Transaction.Terminated);
        try {
            this.template.execute(tx -> {
                throw error;
            });
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
        try {
            this.template.execute(tx -> {
                throw terminatedException;
            });
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.monitor.numRetry, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat(this.monitor.failures, (Matcher)Matchers.contains((Object[])new Throwable[]{error, terminatedException}));
        Assert.assertThat(this.monitor.fails, (Matcher)Matchers.contains((Object[])new Throwable[]{error, terminatedException}));
    }

    @Test
    public void overrideRetryExceptions() {
        this.template = this.template.retryOn(e -> !IllegalArgumentException.class.isInstance(e));
        IllegalArgumentException e2 = new IllegalArgumentException();
        try {
            this.template.execute(tx -> {
                throw e2;
            });
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.monitor.numRetry, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat(this.monitor.failures, (Matcher)Matchers.contains((Object[])new Throwable[]{e2}));
        Assert.assertThat(this.monitor.fails, (Matcher)Matchers.contains((Object[])new Throwable[]{e2}));
    }

    @Test
    public void overrideRetryShouldOverrideDefaults() {
        this.template = this.template.retryOn(e -> !IllegalArgumentException.class.isInstance(e));
        TransactionTerminatedException fakeException = new TransactionTerminatedException((Status)Status.Transaction.Terminated);
        this.template.execute((Consumer)new FailingRetryConsumer(1, (RuntimeException)fakeException));
        Assert.assertThat((Object)this.monitor.numRetry, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat(this.monitor.failures, (Matcher)Matchers.contains((Object[])new Throwable[]{fakeException}));
        Assert.assertThat(this.monitor.fails, (Matcher)Matchers.empty());
    }

    private static class CountingMonitor
    implements TransactionTemplate.Monitor {
        int numRetry;
        List<Throwable> fails = new ArrayList<Throwable>();
        List<Throwable> failures = new ArrayList<Throwable>();

        private CountingMonitor() {
        }

        public void failure(Throwable ex) {
            this.failures.add(ex);
        }

        public void failed(Throwable ex) {
            this.fails.add(ex);
        }

        public void retrying() {
            ++this.numRetry;
        }
    }

    private static class FailingRetryConsumer
    implements Consumer<Transaction> {
        private final int successAfter;
        private final RuntimeException fakeException;
        private int tries;

        private FailingRetryConsumer(int successAfter, RuntimeException fakeException) {
            this.successAfter = successAfter;
            this.fakeException = fakeException;
        }

        @Override
        public void accept(Transaction transaction) {
            if (this.tries++ < this.successAfter) {
                throw this.fakeException;
            }
        }
    }
}

