/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.BatchingMultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.id.IdController;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.util.FeatureToggles;

public class IndexPopulationMissConcurrentUpdateIT {
    private static final String NAME_PROPERTY = "name";
    private static final long INITIAL_CREATION_NODE_ID_THRESHOLD = 30L;
    private static final long SCAN_BARRIER_NODE_ID_THRESHOLD = 10L;
    private final ControlledSchemaIndexProvider index = new ControlledSchemaIndexProvider();
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule(){

        protected GraphDatabaseFactory newFactory() {
            TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
            return factory.addKernelExtension((KernelExtensionFactory)IndexPopulationMissConcurrentUpdateIT.this.index);
        }
    }.withSetting(GraphDatabaseSettings.multi_threaded_schema_index_population_enabled, "false").withSetting(GraphDatabaseSettings.default_schema_provider, ControlledSchemaIndexProvider.INDEX_PROVIDER.name());

    @Before
    public void setFeatureToggle() {
        FeatureToggles.set(MultipleIndexPopulator.class, (String)"batch_size", (Object)1);
        FeatureToggles.set(BatchingMultipleIndexPopulator.class, (String)"batch_size", (Object)1);
        FeatureToggles.set(MultipleIndexPopulator.class, (String)"queue_threshold", (Object)1);
        FeatureToggles.set(BatchingMultipleIndexPopulator.class, (String)"queue_threshold", (Object)1);
    }

    @After
    public void resetFeatureToggle() {
        FeatureToggles.clear(MultipleIndexPopulator.class, (String)"batch_size");
        FeatureToggles.clear(BatchingMultipleIndexPopulator.class, (String)"batch_size");
        FeatureToggles.clear(MultipleIndexPopulator.class, (String)"queue_threshold");
        FeatureToggles.clear(BatchingMultipleIndexPopulator.class, (String)"queue_threshold");
    }

    @Test(timeout=60000L)
    public void shouldNoticeConcurrentUpdatesWithinCurrentLabelIndexEntryRange() throws Exception {
        Node node2;
        ArrayList<Node> nodes = new ArrayList<Node>();
        int nextId = 0;
        try (Transaction tx = this.db.beginTx();){
            do {
                node2 = this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
                node2.setProperty(NAME_PROPERTY, (Object)("Node " + nextId++));
                nodes.add(node2);
            } while (node2.getId() < 30L);
            tx.success();
        }
        Assert.assertThat((String)"At least one node below the scan barrier threshold must have been created, otherwise test assumptions are invalid or outdated", (Object)Iterables.count((Iterable)Iterables.filter(n -> n.getId() <= 10L, nodes)), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        Assert.assertThat((String)"At least two nodes above the scan barrier threshold and below initial creation threshold must have been created, otherwise test assumptions are invalid or outdated", (Object)Iterables.count((Iterable)Iterables.filter(n -> n.getId() > 10L, nodes)), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(1L)));
        ((IdController)this.db.getDependencyResolver().resolveDependency(IdController.class)).maintenance();
        tx = this.db.beginTx();
        var4_4 = null;
        try {
            this.db.schema().indexFor((Label)TestLabels.LABEL_ONE).on(NAME_PROPERTY).create();
            tx.success();
        }
        catch (Throwable node2) {
            var4_4 = node2;
            throw node2;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node2) {
                        var4_4.addSuppressed(node2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.index.barrier.await();
        tx = this.db.beginTx();
        var4_4 = null;
        try {
            do {
                node2 = this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
                node2.setProperty(NAME_PROPERTY, (Object)nextId++);
                nodes.add(node2);
            } while (node2.getId() < this.index.populationAtId);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.index.barrier.release();
        tx = this.db.beginTx();
        var4_4 = null;
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((long)nodes.size(), (long)(this.index.entitiesByScan.size() + this.index.entitiesByUpdater.size()));
        tx = this.db.beginTx();
        var4_4 = null;
        try {
            for (Node node3 : this.db.getAllNodes()) {
                Assert.assertTrue((this.index.entitiesByScan.contains(node3.getId()) || this.index.entitiesByUpdater.contains(node3.getId()) ? 1 : 0) != 0);
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static class ControlledSchemaIndexProvider
    extends KernelExtensionFactory<Supplier> {
        private final Barrier.Control barrier = new Barrier.Control();
        private final Set<Long> entitiesByScan = new ConcurrentSkipListSet<Long>();
        private final Set<Long> entitiesByUpdater = new ConcurrentSkipListSet<Long>();
        private volatile long populationAtId;
        static IndexProviderDescriptor INDEX_PROVIDER = new IndexProviderDescriptor("controlled", "1");

        ControlledSchemaIndexProvider() {
            super(ExtensionType.DATABASE, "controlled");
        }

        public Lifecycle newInstance(KernelContext context, Supplier noDependencies) {
            return new IndexProvider(INDEX_PROVIDER, IndexDirectoryStructure.directoriesByProvider((File)new File("not-even-persistent"))){

                public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, TokenNameLookup tokenNameLookup) {
                    return new IndexPopulator(){

                        public void create() {
                        }

                        public void drop() {
                        }

                        public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
                            for (IndexEntryUpdate<?> update : updates) {
                                boolean added = entitiesByScan.add(update.getEntityId());
                                Assert.assertTrue((boolean)added);
                                if (update.getEntityId() <= 10L) continue;
                                populationAtId = update.getEntityId();
                                barrier.reached();
                            }
                        }

                        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
                        }

                        public IndexUpdater newPopulatingUpdater(NodePropertyAccessor nodePropertyAccessor) {
                            return new IndexUpdater(){

                                public void process(IndexEntryUpdate<?> update) {
                                    boolean added = entitiesByUpdater.add(update.getEntityId());
                                    Assert.assertTrue((boolean)added);
                                }

                                public void close() {
                                }
                            };
                        }

                        public void close(boolean populationCompletedSuccessfully) {
                            Assert.assertTrue((boolean)populationCompletedSuccessfully);
                        }

                        public void markAsFailed(String failure) {
                            throw new UnsupportedOperationException();
                        }

                        public void includeSample(IndexEntryUpdate<?> update) {
                        }

                        public IndexSample sampleResult() {
                            return new IndexSample(0L, 0L, 0L);
                        }
                    };
                }

                public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) {
                    return (IndexAccessor)Mockito.mock(IndexAccessor.class);
                }

                public String getPopulationFailure(StoreIndexDescriptor descriptor) {
                    throw new IllegalStateException();
                }

                public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
                    return InternalIndexState.POPULATING;
                }

                public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
                    return IndexCapability.NO_CAPABILITY;
                }

                public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
                    return StoreMigrationParticipant.NOT_PARTICIPATING;
                }
            };
        }
    }
}

