/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.GroupingRecoveryCleanupWorkCollector;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.labelscan.LabelScanStoreTest;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;

public class NativeLabelScanStoreStartupIT {
    private static final Label LABEL = Label.label((String)"testLabel");
    @Rule
    public final DatabaseRule dbRule = new EmbeddedDatabaseRule();
    @Rule
    public final RandomRule random = new RandomRule();
    private int labelId;

    @Test
    public void scanStoreStartWithoutExistentIndex() throws Throwable {
        LabelScanStore labelScanStore = this.getLabelScanStore();
        GroupingRecoveryCleanupWorkCollector workCollector = this.getGroupingRecoveryCleanupWorkCollector();
        labelScanStore.shutdown();
        workCollector.shutdown();
        NativeLabelScanStoreStartupIT.deleteLabelScanStoreFiles(this.dbRule.databaseLayout());
        workCollector.init();
        labelScanStore.init();
        workCollector.start();
        labelScanStore.start();
        NativeLabelScanStoreStartupIT.checkLabelScanStoreAccessible(labelScanStore);
    }

    @Test
    public void scanStoreRecreateCorruptedIndexOnStartup() throws Throwable {
        LabelScanStore labelScanStore = this.getLabelScanStore();
        GroupingRecoveryCleanupWorkCollector workCollector = this.getGroupingRecoveryCleanupWorkCollector();
        this.createTestNode();
        long[] labels = this.readNodesForLabel(labelScanStore);
        Assert.assertEquals((String)"Label scan store see 1 label for node", (long)1L, (long)labels.length);
        labelScanStore.force(IOLimiter.UNLIMITED);
        labelScanStore.shutdown();
        workCollector.shutdown();
        this.corruptLabelScanStoreFiles(this.dbRule.databaseLayout());
        workCollector.init();
        labelScanStore.init();
        workCollector.start();
        labelScanStore.start();
        long[] rebuildLabels = this.readNodesForLabel(labelScanStore);
        Assert.assertArrayEquals((String)"Store should rebuild corrupted index", (long[])labels, (long[])rebuildLabels);
    }

    private LabelScanStore getLabelScanStore() {
        return this.getDependency(LabelScanStore.class);
    }

    private GroupingRecoveryCleanupWorkCollector getGroupingRecoveryCleanupWorkCollector() {
        return (GroupingRecoveryCleanupWorkCollector)this.dbRule.getDependencyResolver().resolveDependency(GroupingRecoveryCleanupWorkCollector.class);
    }

    private <T> T getDependency(Class<T> clazz) {
        return (T)this.dbRule.getDependencyResolver().resolveDependency(clazz);
    }

    private long[] readNodesForLabel(LabelScanStore labelScanStore) {
        try (LabelScanReader reader = labelScanStore.newReader();){
            long[] lArray = PrimitiveLongCollections.asArray((LongIterator)reader.nodesWithLabel(this.labelId));
            return lArray;
        }
    }

    private Node createTestNode() {
        Node node;
        try (Transaction transaction = this.dbRule.beginTx();){
            node = this.dbRule.createNode(new Label[]{LABEL});
            KernelTransaction ktx = ((ThreadToStatementContextBridge)this.dbRule.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
            this.labelId = ktx.tokenRead().nodeLabel(LABEL.name());
            transaction.success();
        }
        return node;
    }

    private void scrambleFile(File file) throws IOException {
        LabelScanStoreTest.scrambleFile((Random)this.random.random(), (File)file);
    }

    private static File storeFile(DatabaseLayout databaseLayout) {
        return databaseLayout.labelScanStore();
    }

    private void corruptLabelScanStoreFiles(DatabaseLayout databaseLayout) throws IOException {
        this.scrambleFile(NativeLabelScanStoreStartupIT.storeFile(databaseLayout));
    }

    private static void deleteLabelScanStoreFiles(DatabaseLayout databaseLayout) {
        Assert.assertTrue((boolean)NativeLabelScanStoreStartupIT.storeFile(databaseLayout).delete());
    }

    private static void checkLabelScanStoreAccessible(LabelScanStore labelScanStore) throws IOException {
        int labelId = 1;
        try (LabelScanWriter labelScanWriter = labelScanStore.newWriter();){
            labelScanWriter.write(NodeLabelUpdate.labelChanges((long)1L, (long[])new long[0], (long[])new long[]{labelId}));
        }
        var3_3 = null;
        try (LabelScanReader labelScanReader = labelScanStore.newReader();){
            Assert.assertEquals((long)1L, (long)labelScanReader.nodesWithLabel(labelId).next());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }
}

