/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.concurrent.TimeUnit;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class SchemaLoggingIT {
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    @Rule
    public final ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule((LogProvider)this.logProvider);

    @Test
    public void shouldLogUserReadableLabelAndPropertyNames() throws Exception {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        String labelName = "User";
        String property = "name";
        SchemaLoggingIT.createIndex(db, labelName, property);
        AssertableLogProvider.LogMatcherBuilder match = AssertableLogProvider.inLog(IndexPopulationJob.class);
        IndexProviderMap indexProviderMap = (IndexProviderMap)db.getDependencyResolver().resolveDependency(IndexProviderMap.class);
        IndexProvider defaultProvider = indexProviderMap.getDefaultProvider();
        IndexProviderDescriptor providerDescriptor = defaultProvider.getProviderDescriptor();
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{match.info("Index population started: [%s]", new Object[]{":User(name) [provider: {key=" + providerDescriptor.getKey() + ", version=" + providerDescriptor.getVersion() + "}]"})});
        Assert.assertEventually(() -> null, (Matcher)new LogMessageMatcher(match, providerDescriptor), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static void createIndex(GraphDatabaseAPI db, String labelName, String property) {
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(Label.label((String)labelName)).on(property).create();
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private class LogMessageMatcher
    extends BaseMatcher<Object> {
        private static final String CREATION_FINISHED = "Index creation finished for index [%s].";
        private final AssertableLogProvider.LogMatcherBuilder match;
        private final IndexProviderDescriptor descriptor;

        LogMessageMatcher(AssertableLogProvider.LogMatcherBuilder match, IndexProviderDescriptor descriptor) {
            this.match = match;
            this.descriptor = descriptor;
        }

        public boolean matches(Object item) {
            return SchemaLoggingIT.this.logProvider.containsMatchingLogCall(this.match.info(CREATION_FINISHED, new Object[]{":User(name) [provider: {key=" + this.descriptor.getKey() + ", version=" + this.descriptor.getVersion() + "}]"}));
        }

        public void describeTo(Description description) {
            description.appendText(" expected log message: '").appendText(CREATION_FINISHED).appendText("', but not found. Messages was: '").appendText(SchemaLoggingIT.this.logProvider.serialize()).appendText(".");
        }
    }
}

