/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.ClockContext;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.lock.LockTracer;
import org.neo4j.test.TestGraphDatabaseFactory;

public abstract class RecordStorageReaderTestBase {
    protected GraphDatabaseAPI db;
    protected final Label label1 = Label.label((String)"FirstLabel");
    protected final Label label2 = Label.label((String)"SecondLabel");
    protected final RelationshipType relType1 = RelationshipType.withName((String)"type1");
    protected final RelationshipType relType2 = RelationshipType.withName((String)"type2");
    protected final String propertyKey = "name";
    protected final String otherPropertyKey = "age";
    protected KernelStatement state;
    protected StorageReader storageReader;

    @Before
    public void before() {
        this.db = (GraphDatabaseAPI)this.createGraphDatabase();
        DependencyResolver resolver = this.db.getDependencyResolver();
        this.storageReader = ((StorageEngine)resolver.resolveDependency(StorageEngine.class)).newReader();
        this.state = new KernelStatement(null, null, this.storageReader, LockTracer.NONE, null, new ClockContext(), EmptyVersionContextSupplier.EMPTY);
    }

    protected GraphDatabaseService createGraphDatabase() {
        return new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    protected static Node createLabeledNode(GraphDatabaseService db, Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    protected int labelId(Label label) {
        try (Transaction tx = this.db.beginTx();){
            int id = this.ktx().tokenRead().nodeLabel(label.name());
            tx.success();
            int n = id;
            return n;
        }
    }

    protected int relationshipTypeId(RelationshipType type) {
        try (Transaction tx = this.db.beginTx();){
            int id = this.ktx().tokenRead().relationshipType(type.name());
            tx.success();
            int n = id;
            return n;
        }
    }

    protected String relationshipType(int id) throws KernelException {
        try (Transaction tx = this.db.beginTx();){
            String name = this.ktx().tokenRead().relationshipTypeName(id);
            tx.success();
            String string = name;
            return string;
        }
    }

    protected int propertyKeyId(String propertyKey) {
        try (Transaction tx = this.db.beginTx();){
            int id = this.ktx().tokenRead().propertyKey(propertyKey);
            tx.success();
            int n = id;
            return n;
        }
    }

    protected KernelTransaction ktx() {
        DependencyResolver dependencyResolver = this.db.getDependencyResolver();
        return ((ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
    }
}

