/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class DenseNodeIT {
    @Rule
    public ImpermanentDatabaseRule databaseRule = new ImpermanentDatabaseRule();

    @Test
    public void testBringingNodeOverDenseThresholdIsConsistent() {
        Node root;
        GraphDatabaseAPI db = this.databaseRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            root = db.createNode();
            this.createRelationshipsOnNode((GraphDatabaseService)db, root, 40);
            tx.success();
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            this.createRelationshipsOnNode((GraphDatabaseService)db, root, 60);
            Assert.assertEquals((long)100L, (long)root.getDegree());
            Assert.assertEquals((long)100L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)root.getDegree(RelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)root.getDegree(RelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)root.getDegree(RelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)root.getDegree(RelationshipType.withName((String)"Type3")));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            Assert.assertEquals((long)100L, (long)root.getDegree());
            Assert.assertEquals((long)100L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)root.getDegree(RelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)root.getDegree(RelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)root.getDegree(RelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)root.getDegree(RelationshipType.withName((String)"Type3")));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void deletingRelationshipsFromDenseNodeIsConsistent() {
        Node root;
        GraphDatabaseAPI db = this.databaseRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            root = db.createNode();
            this.createRelationshipsOnNode((GraphDatabaseService)db, root, 100);
            tx.success();
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            this.deleteRelationshipsFromNode(root, 80);
            Assert.assertEquals((long)20L, (long)root.getDegree());
            Assert.assertEquals((long)20L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            Assert.assertEquals((long)20L, (long)root.getDegree());
            Assert.assertEquals((long)20L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void movingBilaterallyOfTheDenseNodeThresholdIsConsistent() {
        Node root;
        GraphDatabaseAPI db = this.databaseRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            root = db.createNode();
            this.createRelationshipsOnNode((GraphDatabaseService)db, root, 100);
            this.deleteRelationshipsFromNode(root, 80);
            Assert.assertEquals((long)20L, (long)root.getDegree());
            Assert.assertEquals((long)20L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            tx.success();
        }
        tx = db.beginTx();
        var4_3 = null;
        try {
            Assert.assertEquals((long)20L, (long)root.getDegree());
            Assert.assertEquals((long)20L, (long)root.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)root.getDegree(Direction.INCOMING));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void testBringingTwoConnectedNodesOverDenseThresholdIsConsistent() {
        Node sink;
        Node source;
        GraphDatabaseAPI db = this.databaseRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            source = db.createNode();
            sink = db.createNode();
            this.createRelationshipsBetweenNodes(source, sink, 40);
            tx.success();
        }
        tx = db.beginTx();
        var5_3 = null;
        try {
            this.createRelationshipsBetweenNodes(source, sink, 60);
            Assert.assertEquals((long)100L, (long)source.getDegree());
            Assert.assertEquals((long)100L, (long)source.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)source.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)source.getDegree(RelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)source.getDegree(RelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)source.getDegree(RelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)source.getDegree(RelationshipType.withName((String)"Type3")));
            Assert.assertEquals((long)100L, (long)sink.getDegree());
            Assert.assertEquals((long)0L, (long)sink.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)100L, (long)sink.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)sink.getDegree(RelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)sink.getDegree(RelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)sink.getDegree(RelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)sink.getDegree(RelationshipType.withName((String)"Type3")));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var5_3 = null;
        try {
            Assert.assertEquals((long)100L, (long)source.getDegree());
            Assert.assertEquals((long)100L, (long)source.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)0L, (long)source.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)source.getDegree(RelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)source.getDegree(RelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)source.getDegree(RelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)source.getDegree(RelationshipType.withName((String)"Type3")));
            Assert.assertEquals((long)100L, (long)sink.getDegree());
            Assert.assertEquals((long)0L, (long)sink.getDegree(Direction.OUTGOING));
            Assert.assertEquals((long)100L, (long)sink.getDegree(Direction.INCOMING));
            Assert.assertEquals((long)25L, (long)sink.getDegree(RelationshipType.withName((String)"Type0")));
            Assert.assertEquals((long)25L, (long)sink.getDegree(RelationshipType.withName((String)"Type1")));
            Assert.assertEquals((long)25L, (long)sink.getDegree(RelationshipType.withName((String)"Type2")));
            Assert.assertEquals((long)25L, (long)sink.getDegree(RelationshipType.withName((String)"Type3")));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToCreateRelationshipsInEmptyDenseNode() {
        Relationship rel;
        Node node;
        try (Transaction tx = this.databaseRule.beginTx();){
            node = this.databaseRule.createNode();
            this.createRelationshipsBetweenNodes(node, this.databaseRule.createNode(), this.denseNodeThreshold((GraphDatabaseAPI)this.databaseRule) + 1);
            tx.success();
        }
        tx = this.databaseRule.beginTx();
        var3_2 = null;
        try {
            node.getRelationships().forEach(Relationship::delete);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        try (Transaction tx = this.databaseRule.beginTx();){
            rel = node.createRelationshipTo(this.databaseRule.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        tx = this.databaseRule.beginTx();
        var4_8 = null;
        try {
            Assert.assertEquals((Object)rel, (Object)Iterables.single((Iterable)node.getRelationships()));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private int denseNodeThreshold(GraphDatabaseAPI db) {
        return (Integer)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(GraphDatabaseSettings.dense_node_threshold);
    }

    private void deleteRelationshipsFromNode(Node root, int numberOfRelationships) {
        int deleted = 0;
        try (ResourceIterator iterator = Iterators.asResourceIterator(root.getRelationships().iterator());){
            while (iterator.hasNext()) {
                Relationship relationship = (Relationship)iterator.next();
                relationship.delete();
                if (++deleted != numberOfRelationships) continue;
                break;
            }
        }
    }

    private void createRelationshipsOnNode(GraphDatabaseService db, Node root, int numberOfRelationships) {
        for (int i = 0; i < numberOfRelationships; ++i) {
            root.createRelationshipTo(db.createNode(), RelationshipType.withName((String)("Type" + i % 4))).setProperty("" + i, (Object)i);
        }
    }

    private void createRelationshipsBetweenNodes(Node source, Node sink, int numberOfRelationships) {
        for (int i = 0; i < numberOfRelationships; ++i) {
            source.createRelationshipTo(sink, RelationshipType.withName((String)("Type" + i % 4))).setProperty("" + i, (Object)i);
        }
    }
}

