/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class SimpleRandomizedIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    public SimpleRandomizedIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, TestIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100}));
    }

    @Test
    public void testExactMatchOnRandomValues() throws Exception {
        ValueType[] types = this.randomSetOfSupportedTypes();
        List<Value> values = this.generateValuesFromType(types, new HashSet<Value>(), 30000);
        List<IndexEntryUpdate<?>> updates = this.generateUpdatesFromValues(values, new MutableLong());
        this.updateAndCommit(updates);
        for (IndexEntryUpdate<?> update : updates) {
            List<Long> hits = this.query(new IndexQuery[]{IndexQuery.exact((int)0, (Object)update.values()[0])});
            Assert.assertEquals((String)hits.toString(), (long)1L, (long)hits.size());
            Assert.assertThat((Object)Iterables.single(hits), (Matcher)Matchers.equalTo((Object)update.getEntityId()));
        }
    }

    @Test
    public void testRangeMatchInOrderOnRandomValues() throws Exception {
        Assume.assumeTrue((String)"Assume support for granular composite queries", (boolean)this.testSuite.supportsGranularCompositeQueries());
        ValueType[] types = this.randomSetOfSupportedAndSortableTypes();
        HashSet<Value> uniqueValues = new HashSet<Value>();
        TreeSet<ValueAndId> sortedValues = new TreeSet<ValueAndId>((v1, v2) -> Values.COMPARATOR.compare(((ValueAndId)v1).value, ((ValueAndId)v2).value));
        MutableLong nextId = new MutableLong();
        for (int i = 0; i < 5; ++i) {
            List<IndexEntryUpdate<?>> updates = new ArrayList();
            if (i == 0) {
                updates = this.generateUpdatesFromValues(this.generateValuesFromType(types, uniqueValues, 20000), nextId);
                sortedValues.addAll(updates.stream().map(u -> new ValueAndId(u.values()[0], u.getEntityId())).collect(Collectors.toList()));
            } else {
                for (int j = 0; j < 1000; ++j) {
                    ValueAndId existing;
                    int type = this.random.intBetween(0, 2);
                    if (type == 0) {
                        Value value = this.generateUniqueRandomValue(types, uniqueValues);
                        long id = nextId.getAndIncrement();
                        sortedValues.add(new ValueAndId(value, id));
                        updates.add(IndexQueryHelper.add((long)id, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{value}));
                        continue;
                    }
                    if (type == 1) {
                        existing = (ValueAndId)this.random.among((Object[])sortedValues.toArray(new ValueAndId[0]));
                        sortedValues.remove(existing);
                        Value newValue = this.generateUniqueRandomValue(types, uniqueValues);
                        uniqueValues.remove(existing.value);
                        sortedValues.add(new ValueAndId(newValue, existing.id));
                        updates.add(IndexEntryUpdate.change((long)existing.id, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value)existing.value, (Value)newValue));
                        continue;
                    }
                    existing = (ValueAndId)this.random.among((Object[])sortedValues.toArray(new ValueAndId[0]));
                    sortedValues.remove(existing);
                    uniqueValues.remove(existing.value);
                    updates.add(IndexEntryUpdate.remove((long)existing.id, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])new Value[]{existing.value}));
                }
            }
            this.updateAndCommit(updates);
            this.verifyRandomRanges(types, sortedValues);
        }
    }

    private void verifyRandomRanges(ValueType[] types, TreeSet<ValueAndId> sortedValues) throws Exception {
        for (int i = 0; i < 100; ++i) {
            IndexOrder[] indexOrders;
            Value to;
            ValueType type = (ValueType)this.random.among((Object[])types);
            Value from = this.random.randomValues().nextValueOfType(type);
            if (Values.COMPARATOR.compare(from, to = this.random.randomValues().nextValueOfType(type)) > 0) {
                Value tmp = from;
                from = to;
                to = tmp;
            }
            boolean fromInclusive = this.random.nextBoolean();
            boolean toInclusive = this.random.nextBoolean();
            IndexQuery.RangePredicate predicate = IndexQuery.range((int)0, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive);
            List<Long> expectedIds = this.expectedIds(sortedValues, from, to, fromInclusive, toInclusive);
            for (IndexOrder order : indexOrders = this.indexProvider.getCapability(this.descriptor).orderCapability(new ValueCategory[]{predicate.valueGroup().category()})) {
                List<Long> actualIds = this.assertInOrder(order, new IndexQuery[]{predicate});
                actualIds.sort(Long::compare);
                Assert.assertThat(actualIds, (Matcher)Matchers.equalTo(expectedIds));
            }
        }
    }

    private List<Long> expectedIds(TreeSet<ValueAndId> sortedValues, Value from, Value to, boolean fromInclusive, boolean toInclusive) {
        return sortedValues.subSet(new ValueAndId(from, 0L), fromInclusive, new ValueAndId(to, 0L), toInclusive).stream().map(v -> ((ValueAndId)v).id).sorted(Long::compare).collect(Collectors.toList());
    }

    private List<Value> generateValuesFromType(ValueType[] types, Set<Value> duplicateChecker, int count) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (long i = 0L; i < (long)count; ++i) {
            Value value = this.generateUniqueRandomValue(types, duplicateChecker);
            values.add(value);
        }
        return values;
    }

    private Value generateUniqueRandomValue(ValueType[] types, Set<Value> duplicateChecker) {
        Value value;
        while (!duplicateChecker.add(value = this.random.randomValues().nextValueOfTypes(types))) {
        }
        return value;
    }

    private List<IndexEntryUpdate<?>> generateUpdatesFromValues(List<Value> values, MutableLong nextId) {
        ArrayList updates = new ArrayList();
        for (Value value : values) {
            IndexEntryUpdate update = IndexQueryHelper.add((long)nextId.getAndIncrement(), (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{value});
            updates.add(update);
        }
        return updates;
    }

    private static class ValueAndId {
        private final Value value;
        private final long id;

        ValueAndId(Value value, long id) {
            this.value = value;
            this.id = id;
        }
    }
}

