/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.ByteUnit;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class FailedIndexRestartIT {
    private static final String ROBOT = "Robot";
    private static final String GENDER = "gender";
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule();

    @Test
    public void failedIndexUpdatesAfterRestart() throws IOException {
        Label robot = Label.label((String)ROBOT);
        String megaProperty = RandomStringUtils.randomAlphanumeric((int)((int)ByteUnit.mebiBytes((long)16L)));
        this.createNodeWithProperty(robot, megaProperty);
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(robot).on(GENDER).create();
            tx.success();
        }
        try {
            this.awaitIndexesOnline();
            Assert.fail((String)"Index population should fail on entry size limit");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e).getMessage(), (Matcher)Matchers.containsString((String)"Index key-value size it to large."));
        }
        this.createNodeWithProperty(robot, megaProperty);
        var4_5 = null;
        try (Transaction transaction = this.db.beginTx();){
            Assert.assertEquals((long)2L, (long)Iterators.count((Iterator)this.db.findNodes(robot)));
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        this.db.restartDatabase(new String[0]);
        this.createNodeWithProperty(robot, megaProperty);
        transaction = this.db.beginTx();
        var4_5 = null;
        try {
            Assert.assertEquals((long)3L, (long)Iterators.count((Iterator)this.db.findNodes(robot)));
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var4_5 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    private void createNodeWithProperty(Label label, String propertyValue) {
        try (Transaction transaction = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{label});
            node.setProperty(GENDER, (Object)propertyValue);
            transaction.success();
        }
    }

    private void awaitIndexesOnline() {
        try (Transaction ignored = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(3L, TimeUnit.MINUTES);
        }
    }
}

