/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class LabelIT
extends KernelIntegrationTest {
    @Test
    public void shouldListAllLabels() throws Exception {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int label1Id = transaction.tokenWrite().labelGetOrCreateForName("label1");
        int label2Id = transaction.tokenWrite().labelGetOrCreateForName("label2");
        Iterator labelIdsBeforeCommit = transaction.tokenRead().labelsGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)labelIdsBeforeCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new NamedToken[]{new NamedToken("label1", label1Id), new NamedToken("label2", label2Id)}));
        this.commit();
        transaction = this.newTransaction();
        Iterator labelIdsAfterCommit = transaction.tokenRead().labelsGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)labelIdsAfterCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new NamedToken[]{new NamedToken("label1", label1Id), new NamedToken("label2", label2Id)}));
        this.commit();
    }
}

