/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.test.rule.TestDirectory;

public class CommitContentionTest {
    @Rule
    public final TestDirectory storeLocation = TestDirectory.testDirectory();
    final Semaphore semaphore1 = new Semaphore(1);
    final Semaphore semaphore2 = new Semaphore(1);
    final AtomicReference<Exception> reference = new AtomicReference();
    private GraphDatabaseService db;

    @Before
    public void before() throws Exception {
        this.semaphore1.acquire();
        this.semaphore2.acquire();
        this.db = this.createDb();
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    @Test
    public void shouldNotContendOnCommitWhenPushingUpdates() throws Exception {
        Thread thread = this.startFirstTransactionWhichBlocksDuringPushUntilSecondTransactionFinishes();
        this.runAndFinishSecondTransaction();
        thread.join();
        this.assertNoFailures();
    }

    private void assertNoFailures() {
        Exception e = this.reference.get();
        if (e != null) {
            throw new AssertionError((Object)e);
        }
    }

    private void runAndFinishSecondTransaction() {
        this.createNode();
        this.signalSecondTransactionFinished();
    }

    private void createNode() {
        try (Transaction transaction = this.db.beginTx();){
            this.db.createNode();
            transaction.success();
        }
    }

    private Thread startFirstTransactionWhichBlocksDuringPushUntilSecondTransactionFinishes() throws InterruptedException {
        Thread thread = new Thread(this::createNode);
        thread.start();
        this.waitForFirstTransactionToStartPushing();
        return thread;
    }

    private GraphDatabaseService createDb() {
        GraphDatabaseFactoryState state = new GraphDatabaseFactoryState();
        return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, platformModule -> new CommunityEditionModule((PlatformModule)platformModule){

            public DatabaseTransactionStats createTransactionMonitor() {
                return new SkipTransactionDatabaseStats();
            }
        }).newFacade(this.storeLocation.storeDir(), Config.defaults(), state.databaseDependencies());
    }

    private void waitForFirstTransactionToStartPushing() throws InterruptedException {
        if (!this.semaphore1.tryAcquire(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("First transaction never started pushing");
        }
    }

    private void signalFirstTransactionStartedPushing() {
        this.semaphore1.release();
    }

    private void signalSecondTransactionFinished() {
        this.semaphore2.release();
    }

    private void waitForSecondTransactionToFinish() {
        try {
            boolean acquired = this.semaphore2.tryAcquire(10L, TimeUnit.SECONDS);
            if (!acquired) {
                this.reference.set(new IllegalStateException("Second transaction never finished"));
            }
        }
        catch (InterruptedException e) {
            this.reference.set(e);
        }
    }

    private class SkipTransactionDatabaseStats
    extends DatabaseTransactionStats {
        boolean skip;

        private SkipTransactionDatabaseStats() {
        }

        public void transactionFinished(boolean committed, boolean write) {
            super.transactionFinished(committed, write);
            if (committed) {
                if (this.skip) {
                    return;
                }
                this.skip = true;
                CommitContentionTest.this.signalFirstTransactionStartedPushing();
                CommitContentionTest.this.waitForSecondTransactionToFinish();
            }
        }
    }
}

