/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class BuiltInDbmsProceduresIT
extends KernelIntegrationTest {
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Test
    public void listConfig() throws Exception {
        List<Object[]> config = this.callListConfig("");
        List names = config.stream().map(o -> o[0].toString()).collect(Collectors.toList());
        Assert.assertTrue((names.size() > 10 ? 1 : 0) != 0);
        Assert.assertThat(names, (Matcher)Matchers.hasItem((Object)GraphDatabaseSettings.record_format.name()));
        Assert.assertEquals((long)names.stream().filter(n -> n.startsWith("unsupported")).count(), (long)0L);
    }

    @Test
    public void listClientConfig() throws Exception {
        QualifiedName procedureName = ProcedureSignature.procedureName((String[])new String[]{"dbms", "clientConfig"});
        int procedureId = this.procs().procedureGet(procedureName).id();
        RawIterator callResult = this.dbmsOperations().procedureCallDbms(procedureId, new Object[0], this.dependencyResolver, SecurityContext.AUTH_DISABLED, this.resourceTracker, ProcedureCallContext.EMPTY);
        List config = Iterators.asList((RawIterator)callResult);
        Assert.assertEquals((long)3L, (long)config.size());
        Assert.assertEquals((Object)((Object[])config.get(0))[0], (Object)"browser.post_connect_cmd");
        Assert.assertEquals((Object)((Object[])config.get(1))[0], (Object)"browser.remote_content_hostname_whitelist");
        Assert.assertEquals((Object)((Object[])config.get(2))[0], (Object)"dbms.security.auth_enabled");
    }

    @Test
    public void listConfigWithASpecificConfigName() throws Exception {
        List<Object[]> config = this.callListConfig(GraphDatabaseSettings.strict_config_validation.name());
        Assert.assertEquals((long)1L, (long)config.size());
        Assert.assertArrayEquals((Object[])new Object[]{"dbms.config.strict_validation", "A strict configuration validation will prevent the database from starting up if unknown configuration options are specified in the neo4j settings namespace (such as dbms., ha., cypher., etc). This is currently false by default but will be true by default in 4.0.", "false", false}, (Object[])config.get(0));
    }

    @Test
    public void durationAlwaysListedWithUnit() throws Exception {
        List<Object[]> config = this.callListConfig(GraphDatabaseSettings.transaction_timeout.name());
        Assert.assertEquals((long)1L, (long)config.size());
        Assert.assertArrayEquals((Object[])new Object[]{"dbms.transaction.timeout", "The maximum time interval of a transaction within which it should be completed.", "0ms", true}, (Object[])config.get(0));
    }

    @Test
    public void listDynamicSetting() throws ProcedureException {
        List<Object[]> config = this.callListConfig(GraphDatabaseSettings.check_point_iops_limit.name());
        Assert.assertEquals((long)1L, (long)config.size());
        Assert.assertTrue((boolean)((Boolean)config.get(0)[3]));
    }

    @Test
    public void listNotDynamicSetting() throws ProcedureException {
        List<Object[]> config = this.callListConfig(GraphDatabaseSettings.data_directory.name());
        Assert.assertEquals((long)1L, (long)config.size());
        Assert.assertFalse((boolean)((Boolean)config.get(0)[3]));
    }

    private List<Object[]> callListConfig(String searchString) throws ProcedureException {
        QualifiedName procedureName = ProcedureSignature.procedureName((String[])new String[]{"dbms", "listConfig"});
        RawIterator callResult = this.dbmsOperations().procedureCallDbms(procedureName, ArrayUtils.toArray((Object[])new String[]{searchString}), this.dependencyResolver, SecurityContext.AUTH_DISABLED, this.resourceTracker, ProcedureCallContext.EMPTY);
        return Iterators.asList((RawIterator)callResult);
    }
}

