/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestShutdownSequence {
    private GraphDatabaseService graphDb;

    @Before
    public void createGraphDb() {
        this.graphDb = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @Test
    public void canInvokeShutdownMultipleTimes() {
        this.graphDb.shutdown();
        this.graphDb.shutdown();
    }

    @Test
    public void eventHandlersAreOnlyInvokedOnceDuringShutdown() {
        final AtomicInteger counter = new AtomicInteger();
        this.graphDb.registerKernelEventHandler(new KernelEventHandler(){

            public void beforeShutdown() {
                counter.incrementAndGet();
            }

            public Object getResource() {
                return null;
            }

            public void kernelPanic(ErrorState error) {
            }

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        });
        this.graphDb.shutdown();
        this.graphDb.shutdown();
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void canRemoveFilesAndReinvokeShutdown() throws IOException {
        GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)this.graphDb;
        FileSystemAbstraction fileSystemAbstraction = TestShutdownSequence.getDatabaseFileSystem(databaseAPI);
        this.graphDb.shutdown();
        fileSystemAbstraction.deleteRecursively(databaseAPI.databaseLayout().databaseDirectory());
        this.graphDb.shutdown();
    }

    @Test
    public void canInvokeShutdownFromShutdownHandler() {
        this.graphDb.registerKernelEventHandler(new KernelEventHandler(){

            public void beforeShutdown() {
                TestShutdownSequence.this.graphDb.shutdown();
            }

            public Object getResource() {
                return null;
            }

            public void kernelPanic(ErrorState error) {
            }

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        });
        this.graphDb.shutdown();
    }

    private static FileSystemAbstraction getDatabaseFileSystem(GraphDatabaseAPI databaseAPI) {
        return (FileSystemAbstraction)databaseAPI.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
    }
}

