/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.matchers.NestedThrowableMatcher;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class LogVersionUpgradeCheckerIT {
    private final TestDirectory storeDirectory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.storeDirectory).around((TestRule)this.fs).around((TestRule)this.pageCacheRule);
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Test
    public void startAsNormalWhenUpgradeIsNotAllowed() {
        this.createGraphDbAndKillIt();
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabaseBuilder(this.storeDirectory.databaseDir()).setConfig(GraphDatabaseSettings.allow_upgrade, "false").newGraphDatabase();
        db.shutdown();
    }

    @Test
    public void failToStartFromOlderTransactionLogsIfNotAllowed() throws Exception {
        this.createStoreWithLogEntryVersion(LogEntryVersion.V2_3);
        this.expect.expect((Matcher)new NestedThrowableMatcher(UpgradeNotAllowedByConfigurationException.class));
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabaseBuilder(this.storeDirectory.databaseDir()).setConfig(GraphDatabaseSettings.allow_upgrade, "false").newGraphDatabase();
        db.shutdown();
    }

    @Test
    public void startFromOlderTransactionLogsIfAllowed() throws Exception {
        this.createStoreWithLogEntryVersion(LogEntryVersion.V2_3);
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabaseBuilder(this.storeDirectory.databaseDir()).setConfig(GraphDatabaseSettings.allow_upgrade, "true").newGraphDatabase();
        db.shutdown();
    }

    private void createGraphDbAndKillIt() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs).newImpermanentDatabaseBuilder(this.storeDirectory.databaseDir()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{Label.label((String)"FOO")});
            db.createNode(new Label[]{Label.label((String)"BAR")});
            tx.success();
        }
        db.shutdown();
    }

    private void createStoreWithLogEntryVersion(LogEntryVersion logEntryVersion) throws Exception {
        this.createGraphDbAndKillIt();
        this.appendCheckpoint(logEntryVersion);
    }

    private void appendCheckpoint(LogEntryVersion logVersion) throws IOException {
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        LogFiles logFiles = LogFilesBuilder.activeFilesBuilder((DatabaseLayout)this.storeDirectory.databaseLayout(), (FileSystemAbstraction)this.fs, (PageCache)pageCache).withLogEntryReader((LogEntryReader)logEntryReader).build();
        LogTailScanner tailScanner = new LogTailScanner(logFiles, (LogEntryReader)logEntryReader, new Monitors());
        LogTailScanner.LogTailInformation tailInformation = tailScanner.getTailInformation();
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{logFiles});){
            FlushablePositionAwareChannel channel = logFiles.getLogFile().getWriter();
            LogPosition logPosition = tailInformation.lastCheckPoint.getLogPosition();
            channel.put(logVersion.byteCode()).put((byte)7).putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset());
            channel.prepareForFlush().flush();
        }
    }
}

