/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.RepeatRule;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.util.concurrent.BinaryLatch;

public class DetachDeleteIT {
    private static ExecutorService executor = Executors.newFixedThreadPool(5);
    @ClassRule
    public static ImpermanentDatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public RepeatRule repeatRule = new RepeatRule();

    @AfterClass
    public static void tearDown() {
        executor.shutdown();
    }

    @Test
    public void detachDeleteMustRemoveAllRelationships() throws Exception {
        long nodeId = this.makeSimpleNode();
        try (Transaction tx = db.beginTx();){
            Write write = this.getWrite();
            Assert.assertEquals((long)10L, (long)write.nodeDetachDelete(nodeId));
            tx.success();
        }
    }

    @Test
    public void detachDeleteMustRemoveAllRelationshipsOfDenseNodes() throws Exception {
        long nodeId = this.makeDenseNode();
        try (Transaction tx = db.beginTx();){
            Write write = this.getWrite();
            Assert.assertEquals((long)100L, (long)write.nodeDetachDelete(nodeId));
            tx.success();
        }
    }

    @RepeatRule.Repeat(times=10)
    @Test
    public void detachDeleteMustRemoveAllRelationshipsWhenMoreAreConcurrentlyAdded() throws Exception {
        long nodeId = this.makeSimpleNode();
        this.verifyDetachDeleteRacingWithRelationCreateWithoutThrowing(nodeId, 1);
    }

    @RepeatRule.Repeat(times=10)
    @Test
    public void detachDeleteMustRemoveAllRelationshipsWhenMoreAreConcurrentlyAddedToMakeNodeDense() throws Exception {
        long nodeId = this.makeSimpleNode();
        this.verifyDetachDeleteRacingWithRelationCreateWithoutThrowing(nodeId, 10);
    }

    @RepeatRule.Repeat(times=10)
    @Test
    public void detachDeleteMustRemoveAllRelationshipsWhenMoreAreConcurrentlyAddedToAlreadyDenseNode() throws Exception {
        long nodeId = this.makeDenseNode();
        this.verifyDetachDeleteRacingWithRelationCreateWithoutThrowing(nodeId, 10);
    }

    @Test
    public void detachDeleteMustLockAllNeighboursIncludingThoseConcurrentlyAdded() throws Exception {
        long otherNodeId;
        Sequencer<Phases> sequencer = Sequencer.from(Phases.class);
        Thread main = Thread.currentThread();
        try (Transaction tx = db.beginTx();){
            otherNodeId = db.createNodeId();
            tx.success();
        }
        long nodeId = this.makeDenseNode();
        AtomicLong otherRelId = new AtomicLong();
        Future<Object> relationshipAdder = executor.submit(() -> {
            try (Transaction tx1 = db.beginTx();){
                Node node = db.getNodeById(nodeId);
                Node other = db.getNodeById(otherNodeId);
                long id = node.createRelationshipTo(other, RelationshipType.withName((String)"R5")).getId();
                otherRelId.set(id);
                tx1.success();
                sequencer.release(Phases.OTHER_REL_CREATED);
                sequencer.await(Phases.DETACH_DELETE_HAS_STARTED);
            }
            return null;
        });
        Future<Object> lockVerifier = executor.submit(() -> {
            sequencer.await(Phases.OTHER_REL_CREATED);
            Predicate predicate = ThreadingRule.waitingWhileIn(RWLock.class, (String)"waitUninterruptedly");
            do {
                Thread.sleep(100L);
            } while (!predicate.test(main));
            sequencer.release(Phases.DETACH_DELETE_HAS_STARTED);
            sequencer.await(Phases.DETACH_DELETE_HAS_FINISHED);
            try (Transaction ignore = db.beginTx();){
                Locks.Client locksClient = this.getLocksClient();
                Assert.assertFalse((boolean)locksClient.trySharedLock((ResourceType)ResourceTypes.NODE, otherNodeId));
                Assertions.assertFalse((boolean)locksClient.trySharedLock((ResourceType)ResourceTypes.RELATIONSHIP, otherRelId.get()));
            }
            finally {
                sequencer.release(Phases.LOCK_VERIFICATION_FINISHED);
            }
            return null;
        });
        sequencer.await(Phases.OTHER_REL_CREATED);
        try (Transaction tx = db.beginTx();){
            Write write = this.getWrite();
            write.nodeDetachDelete(nodeId);
            tx.success();
            sequencer.release(Phases.DETACH_DELETE_HAS_FINISHED);
            sequencer.await(Phases.LOCK_VERIFICATION_FINISHED);
        }
        relationshipAdder.get();
        lockVerifier.get();
    }

    private void verifyDetachDeleteRacingWithRelationCreateWithoutThrowing(long nodeId, int iterPerRelType) throws Exception {
        CountDownLatch latch = new CountDownLatch(5);
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        for (int i = 1; i < 10; ++i) {
            RelationshipType type = RelationshipType.withName((String)("R" + i));
            Callable<Object> callable = () -> {
                latch.countDown();
                latch.await();
                try (Transaction tx = db.beginTx();){
                    Node node = db.getNodeById(nodeId);
                    node.createRelationshipTo(db.createNode(), type);
                    tx.success();
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
                return null;
            };
            for (int j = 0; j < iterPerRelType; ++j) {
                tasks.add(callable);
            }
        }
        tasks.add(() -> {
            latch.countDown();
            latch.await();
            try (Transaction tx = db.beginTx();){
                Write write = this.getWrite();
                write.nodeDetachDelete(nodeId);
                tx.success();
            }
            return null;
        });
        Collections.shuffle(tasks);
        List futures = executor.invokeAll(tasks);
        for (Future future : futures) {
            future.get();
        }
    }

    private long makeSimpleNode() {
        long nodeId;
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            nodeId = node.getId();
            for (int i = 0; i < 10; ++i) {
                node.createRelationshipTo(db.createNode(), RelationshipType.withName((String)("R" + i)));
            }
            tx.success();
        }
        return nodeId;
    }

    private long makeDenseNode() {
        long nodeId;
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            nodeId = node.getId();
            tx.success();
        }
        for (int i = 0; i < 10; ++i) {
            RelationshipType type = RelationshipType.withName((String)("R" + i));
            try (Transaction tx = db.beginTx();){
                Node node = db.getNodeById(nodeId);
                for (int j = 0; j < 10; ++j) {
                    node.createRelationshipTo(db.createNode(), type);
                }
                tx.success();
                continue;
            }
        }
        return nodeId;
    }

    private Write getWrite() throws Exception {
        return this.getKernelTransaction().dataWrite();
    }

    private Locks.Client getLocksClient() {
        KernelTransactionImplementation kti = (KernelTransactionImplementation)this.getKernelTransaction();
        return kti.statementLocks().pessimistic();
    }

    private KernelTransaction getKernelTransaction() {
        ThreadToStatementContextBridge txBridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        return txBridge.getKernelTransactionBoundToThisThread(true);
    }

    private static class Sequencer<E extends Enum<E>> {
        private final EnumMap<E, BinaryLatch> map;

        private Sequencer(EnumMap<E, BinaryLatch> map) {
            this.map = map;
        }

        static <T extends Enum<T>> Sequencer<T> from(Class<T> cls) {
            EnumMap<T, BinaryLatch> map = new EnumMap<T, BinaryLatch>(cls);
            for (Enum phase : (Enum[])cls.getEnumConstants()) {
                map.put((T)phase, new BinaryLatch());
            }
            return new Sequencer<T>(map);
        }

        void await(E phase) {
            this.map.get(phase).await();
        }

        void release(E phase) {
            this.map.get(phase).release();
        }
    }

    static enum Phases {
        OTHER_REL_CREATED,
        DETACH_DELETE_HAS_STARTED,
        DETACH_DELETE_HAS_FINISHED,
        LOCK_VERIFICATION_FINISHED;

    }
}

