/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.index.IndexAccessorCompatibility;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.IndexQueryHelper;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending IndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class CompositeRandomizedIndexAccessorCompatibility
extends IndexAccessorCompatibility {
    public CompositeRandomizedIndexAccessorCompatibility(IndexProviderCompatibilityTestSuite testSuite, IndexDescriptor descriptor) {
        super(testSuite, descriptor);
    }

    private static class ValueAndId {
        private final ValueTuple value;
        private final long id;

        ValueAndId(ValueTuple value, long id) {
            this.value = value;
            this.id = id;
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Range
    extends CompositeRandomizedIndexAccessorCompatibility {
        public Range(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, TestIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100, 101}));
        }

        @Test
        public void testRangeMatchOnRandomValues() throws Exception {
            Assume.assumeTrue((String)"Assume support for granular composite queries", (boolean)this.testSuite.supportsGranularCompositeQueries());
            ValueType[] types = this.randomSetOfSupportedAndSortableTypes();
            HashSet<ValueTuple> uniqueValues = new HashSet<ValueTuple>();
            TreeSet<ValueAndId> sortedValues = new TreeSet<ValueAndId>((v1, v2) -> ValueTuple.COMPARATOR.compare(((ValueAndId)v1).value, ((ValueAndId)v2).value));
            MutableLong nextId = new MutableLong();
            for (int i = 0; i < 5; ++i) {
                List<IndexEntryUpdate<?>> updates = new ArrayList();
                if (i == 0) {
                    updates = this.generateUpdatesFromValues(this.generateValuesFromType(types, uniqueValues, 20000), nextId);
                    sortedValues.addAll(updates.stream().map(u -> new ValueAndId(ValueTuple.of((Value[])u.values()), u.getEntityId())).collect(Collectors.toList()));
                } else {
                    for (int j = 0; j < 1000; ++j) {
                        ValueAndId existing;
                        int type = this.random.intBetween(0, 2);
                        if (type == 0) {
                            ValueTuple value = this.generateUniqueRandomValue(types, uniqueValues);
                            long id = nextId.getAndIncrement();
                            sortedValues.add(new ValueAndId(value, id));
                            updates.add(IndexEntryUpdate.add((long)id, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])value.getValues()));
                            continue;
                        }
                        if (type == 1) {
                            existing = (ValueAndId)this.random.among((Object[])sortedValues.toArray(new ValueAndId[0]));
                            sortedValues.remove(existing);
                            ValueTuple newValue = this.generateUniqueRandomValue(types, uniqueValues);
                            uniqueValues.remove(existing.value);
                            sortedValues.add(new ValueAndId(newValue, existing.id));
                            updates.add(IndexEntryUpdate.change((long)existing.id, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])existing.value.getValues(), (Value[])newValue.getValues()));
                            continue;
                        }
                        existing = (ValueAndId)this.random.among((Object[])sortedValues.toArray(new ValueAndId[0]));
                        sortedValues.remove(existing);
                        uniqueValues.remove(existing.value);
                        updates.add(IndexEntryUpdate.remove((long)existing.id, (SchemaDescriptorSupplier)this.descriptor.schema(), (Value[])existing.value.getValues()));
                    }
                }
                this.updateAndCommit(updates);
                this.verifyRandomRanges(types, sortedValues);
            }
        }

        private void verifyRandomRanges(ValueType[] types, TreeSet<ValueAndId> sortedValues) throws Exception {
            for (int i = 0; i < 100; ++i) {
                IndexOrder[] indexOrders;
                Value to;
                BooleanValue booleanValue = this.random.randomValues().nextBooleanValue();
                ValueType type = (ValueType)this.random.among((Object[])types);
                Value from = this.random.randomValues().nextValueOfType(type);
                if (Values.COMPARATOR.compare(from, to = this.random.randomValues().nextValueOfType(type)) > 0) {
                    Value tmp = from;
                    from = to;
                    to = tmp;
                }
                boolean fromInclusive = this.random.nextBoolean();
                boolean toInclusive = this.random.nextBoolean();
                List<Long> expectedIds = this.expectedIds(sortedValues, (Value)booleanValue, from, to, fromInclusive, toInclusive);
                IndexQuery[] predicates = new IndexQuery[]{IndexQuery.exact((int)100, (Object)booleanValue), IndexQuery.range((int)101, (Value)from, (boolean)fromInclusive, (Value)to, (boolean)toInclusive)};
                ValueCategory[] valueCategories = this.getValueCategories(predicates);
                for (IndexOrder order : indexOrders = this.indexProvider.getCapability(this.descriptor).orderCapability(valueCategories)) {
                    List<Long> actualIds = this.assertInOrder(order, predicates);
                    actualIds.sort(Long::compare);
                    Assert.assertThat(actualIds, (Matcher)Matchers.equalTo(expectedIds));
                }
            }
        }

        public ValueCategory[] getValueCategories(IndexQuery[] predicates) {
            return (ValueCategory[])Arrays.stream(predicates).map(iq -> iq.valueGroup().category()).toArray(ValueCategory[]::new);
        }

        public List<Long> expectedIds(TreeSet<ValueAndId> sortedValues, Value booleanValue, Value from, Value to, boolean fromInclusive, boolean toInclusive) {
            return sortedValues.subSet(new ValueAndId(ValueTuple.of((Value[])new Value[]{booleanValue, from}), 0L), fromInclusive, new ValueAndId(ValueTuple.of((Value[])new Value[]{booleanValue, to}), 0L), toInclusive).stream().map(v -> ((ValueAndId)v).id).sorted(Long::compare).collect(Collectors.toList());
        }

        private List<ValueTuple> generateValuesFromType(ValueType[] types, Set<ValueTuple> duplicateChecker, int count) {
            ArrayList<ValueTuple> values = new ArrayList<ValueTuple>();
            for (long i = 0L; i < (long)count; ++i) {
                ValueTuple value = this.generateUniqueRandomValue(types, duplicateChecker);
                values.add(value);
            }
            return values;
        }

        private ValueTuple generateUniqueRandomValue(ValueType[] types, Set<ValueTuple> duplicateChecker) {
            ValueTuple value;
            while (!duplicateChecker.add(value = ValueTuple.of((Value[])new Value[]{this.random.randomValues().nextBooleanValue(), this.random.randomValues().nextValueOfTypes(types)}))) {
            }
            return value;
        }

        private List<IndexEntryUpdate<?>> generateUpdatesFromValues(List<ValueTuple> values, MutableLong nextId) {
            ArrayList updates = new ArrayList();
            for (ValueTuple value : values) {
                updates.add(IndexQueryHelper.add((long)nextId.getAndIncrement(), (SchemaDescriptor)this.descriptor.schema(), (Object[])value.getValues()));
            }
            return updates;
        }
    }

    @Ignore(value="Not a test. This is a compatibility suite")
    public static class Exact
    extends CompositeRandomizedIndexAccessorCompatibility {
        public Exact(IndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, TestIndexDescriptorFactory.forLabel((int)1000, (int[])new int[]{100, 101, 102, 103}));
        }

        @Test
        public void testExactMatchOnRandomCompositeValues() throws Exception {
            ValueType[] types = this.randomSetOfSupportedTypes();
            ArrayList updates = new ArrayList();
            HashSet<ValueTuple> duplicateChecker = new HashSet<ValueTuple>();
            for (long id = 0L; id < 30000L; ++id) {
                IndexEntryUpdate update;
                while (!duplicateChecker.add(ValueTuple.of((Value[])(update = IndexQueryHelper.add((long)id, (SchemaDescriptor)this.descriptor.schema(), (Object[])new Object[]{this.random.randomValues().nextValueOfTypes(types), this.random.randomValues().nextValueOfTypes(types), this.random.randomValues().nextValueOfTypes(types), this.random.randomValues().nextValueOfTypes(types)})).values()))) {
                }
                updates.add(update);
            }
            this.updateAndCommit(updates);
            for (IndexEntryUpdate indexEntryUpdate : updates) {
                List<Long> hits = this.query(IndexQueryHelper.exact((int)100, (Value)indexEntryUpdate.values()[0]), IndexQueryHelper.exact((int)101, (Value)indexEntryUpdate.values()[1]), IndexQueryHelper.exact((int)102, (Value)indexEntryUpdate.values()[2]), IndexQueryHelper.exact((int)103, (Value)indexEntryUpdate.values()[3]));
                Assert.assertEquals((String)(indexEntryUpdate + " " + hits.toString()), (long)1L, (long)hits.size());
                Assert.assertThat((Object)Iterables.single(hits), (Matcher)Matchers.equalTo((Object)indexEntryUpdate.getEntityId()));
            }
        }
    }
}

