/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyIT
extends KernelIntegrationTest {
    @Test
    public void shouldListAllPropertyKeys() throws Exception {
        this.dbWithNoCache();
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int prop2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop2");
        Iterator propIdsBeforeCommit = transaction.tokenRead().propertyKeyGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)propIdsBeforeCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new NamedToken[]{new NamedToken("prop1", prop1), new NamedToken("prop2", prop2)}));
        this.commit();
        transaction = this.newTransaction();
        Iterator propIdsAfterCommit = transaction.tokenRead().propertyKeyGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)propIdsAfterCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new NamedToken[]{new NamedToken("prop1", prop1), new NamedToken("prop2", prop2)}));
        this.commit();
    }

    @Test
    public void shouldNotAllowModifyingPropertiesOnDeletedRelationship() throws Exception {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int prop1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("prop1");
        int type = transaction.tokenWrite().relationshipTypeGetOrCreateForName("RELATED");
        long startNodeId = transaction.dataWrite().nodeCreate();
        long endNodeId = transaction.dataWrite().nodeCreate();
        long rel = transaction.dataWrite().relationshipCreate(startNodeId, type, endNodeId);
        transaction.dataWrite().relationshipSetProperty(rel, prop1, (Value)Values.stringValue((String)"As"));
        transaction.dataWrite().relationshipDelete(rel);
        try {
            transaction.dataWrite().relationshipRemoveProperty(rel, prop1);
            Assert.fail((String)"Should have failed.");
        }
        catch (EntityNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)("Unable to load RELATIONSHIP with id " + rel + ".")));
        }
        this.commit();
    }

    @Test
    public void shouldBeAbleToRemoveResetAndTwiceRemovePropertyOnRelationship() throws Exception {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int prop = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        int type = transaction.tokenWrite().relationshipTypeGetOrCreateForName("RELATED");
        long startNodeId = transaction.dataWrite().nodeCreate();
        long endNodeId = transaction.dataWrite().nodeCreate();
        long rel = transaction.dataWrite().relationshipCreate(startNodeId, type, endNodeId);
        transaction.dataWrite().relationshipSetProperty(rel, prop, Values.of((Object)"bar"));
        this.commit();
        Write write = this.dataWriteInNewTransaction();
        write.relationshipRemoveProperty(rel, prop);
        write.relationshipSetProperty(rel, prop, Values.of((Object)"bar"));
        write.relationshipRemoveProperty(rel, prop);
        write.relationshipRemoveProperty(rel, prop);
        this.commit();
        transaction = this.newTransaction();
        Assert.assertThat((Object)this.relationshipGetProperty(transaction, rel, prop), (Matcher)CoreMatchers.equalTo((Object)Values.NO_VALUE));
        this.commit();
    }
}

