/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.lang.reflect.Array;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReaderTestBase;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RecordStorageReaderPropertyTest
extends RecordStorageReaderTestBase {
    @Test
    public void shouldGetAllNodeProperties() {
        Object[] properties;
        String longString = "AlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalongAlalalalalong";
        for (Object value : properties = new Object[]{longString, this.createNew(String.class), this.createNew(Long.TYPE), this.createNew(Integer.TYPE), this.createNew(Byte.TYPE), this.createNew(Short.TYPE), this.createNew(Boolean.TYPE), this.createNew(Character.TYPE), this.createNew(Float.TYPE), this.createNew(Double.TYPE), this.array(0, String.class), this.array(0, Long.TYPE), this.array(0, Integer.TYPE), this.array(0, Byte.TYPE), this.array(0, Short.TYPE), this.array(0, Boolean.TYPE), this.array(0, Character.TYPE), this.array(0, Float.TYPE), this.array(0, Double.TYPE), this.array(1, String.class), this.array(1, Long.TYPE), this.array(1, Integer.TYPE), this.array(1, Byte.TYPE), this.array(1, Short.TYPE), this.array(1, Boolean.TYPE), this.array(1, Character.TYPE), this.array(1, Float.TYPE), this.array(1, Double.TYPE), this.array(256, String.class), this.array(256, Long.TYPE), this.array(256, Integer.TYPE), this.array(256, Byte.TYPE), this.array(256, Short.TYPE), this.array(256, Boolean.TYPE), this.array(256, Character.TYPE), this.array(256, Float.TYPE), this.array(256, Double.TYPE)}) {
            long nodeId = RecordStorageReaderPropertyTest.createLabeledNode((GraphDatabaseService)this.db, Collections.singletonMap("prop", value), this.label1).getId();
            try (StorageNodeCursor node = this.storageReader.allocateNodeCursor();){
                node.single(nodeId);
                Assert.assertTrue((boolean)node.next());
                try (StoragePropertyCursor props = this.storageReader.allocatePropertyCursor();){
                    props.init(node.propertiesReference(), node.entityReference(), EntityType.NODE);
                    if (props.next()) {
                        Value propVal = props.propertyValue();
                        Assert.assertTrue((String)(propVal + ".equals(" + value + ")"), (boolean)propVal.equals(Values.of((Object)value)));
                        continue;
                    }
                    Assert.fail();
                }
            }
        }
    }

    private Object array(int length, Class<?> componentType) {
        Object array = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.createNew(componentType));
        }
        return array;
    }

    private Object createNew(Class<?> type) {
        if (type == Integer.TYPE) {
            return 666;
        }
        if (type == Long.TYPE) {
            return 17L;
        }
        if (type == Double.TYPE) {
            return Math.PI * 2;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(3.14f);
        }
        if (type == Short.TYPE) {
            return (short)8733;
        }
        if (type == Byte.TYPE) {
            return (byte)123;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('Z');
        }
        if (type == String.class) {
            return "hello world";
        }
        throw new IllegalArgumentException(type.getName());
    }
}

