/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingStoreChannel;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.StoreLayout;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.internal.locker.StoreLocker;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class StoreLockerTest {
    @Rule
    public final TestDirectory target = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void shouldUseAlreadyOpenedFileChannel() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        CustomChannelFileSystemAbstraction fileSystemAbstraction = new CustomChannelFileSystemAbstraction((DefaultFileSystemAbstraction)this.fileSystemRule.get(), channel);
        int numberOfCallesToOpen = 0;
        try (StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, this.target.storeLayout());){
            try {
                storeLocker.checkLock();
                Assert.fail();
            }
            catch (StoreLockException e) {
                numberOfCallesToOpen = fileSystemAbstraction.getNumberOfCallsToOpen();
                storeLocker.checkLock();
            }
        }
        catch (StoreLockException storeLockException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Expect that number of open channels will remain the same for ", (long)numberOfCallesToOpen, (long)fileSystemAbstraction.getNumberOfCallsToOpen());
    }

    @Test
    public void shouldAllowMultipleCallsToCheckLock() throws Exception {
        try (StoreLocker storeLocker = new StoreLocker(this.fileSystemRule.get(), this.target.storeLayout());){
            storeLocker.checkLock();
            storeLocker.checkLock();
        }
    }

    @Test
    public void keepLockWhenOtherTryToTakeLock() throws Exception {
        Throwable throwable;
        StoreLocker storeLocker12;
        StoreLayout storeLayout = this.target.storeLayout();
        DefaultFileSystemAbstraction fileSystemAbstraction = (DefaultFileSystemAbstraction)this.fileSystemRule.get();
        StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, storeLayout);
        storeLocker.checkLock();
        try {
            storeLocker12 = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, storeLayout);
            throwable = null;
            try {
                storeLocker12.checkLock();
                Assert.fail();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (storeLocker12 != null) {
                    if (throwable != null) {
                        try {
                            storeLocker12.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        storeLocker12.close();
                    }
                }
            }
        }
        catch (StoreLockException storeLocker12) {
            // empty catch block
        }
        try {
            storeLocker12 = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, storeLayout);
            throwable = null;
            try {
                storeLocker12.checkLock();
                Assert.fail();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (storeLocker12 != null) {
                    if (throwable != null) {
                        try {
                            storeLocker12.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        storeLocker12.close();
                    }
                }
            }
        }
        catch (StoreLockException storeLockException) {
            // empty catch block
        }
        storeLocker.close();
    }

    @Test
    public void shouldObtainLockWhenStoreFileNotLocked() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystemRule.get()){

            public boolean fileExists(File file) {
                return true;
            }
        };
        try (StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, this.target.storeLayout());){
            storeLocker.checkLock();
        }
        catch (StoreLockException e) {
            Assert.fail();
        }
    }

    @Test
    public void shouldCreateStoreDirAndObtainLockWhenStoreDirDoesNotExist() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystemRule.get()){

            public boolean fileExists(File file) {
                return false;
            }
        };
        try (StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, this.target.storeLayout());){
            storeLocker.checkLock();
        }
    }

    @Test
    public void shouldNotObtainLockWhenStoreDirCannotBeCreated() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystemRule.get()){

            public void mkdirs(File fileName) throws IOException {
                throw new IOException("store dir could not be created");
            }

            public boolean fileExists(File file) {
                return false;
            }
        };
        StoreLayout storeLayout = this.target.storeLayout();
        try (StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, storeLayout);){
            storeLocker.checkLock();
            Assert.fail();
        }
        catch (StoreLockException e) {
            String msg = String.format("Unable to create path for store dir: %s. Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)", storeLayout);
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)msg));
        }
    }

    @Test
    public void shouldNotObtainLockWhenUnableToOpenLockFile() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystemRule.get()){

            public StoreChannel open(File fileName, OpenMode openMode) throws IOException {
                throw new IOException("cannot open lock file");
            }

            public boolean fileExists(File file) {
                return false;
            }
        };
        StoreLayout storeLayout = this.target.storeLayout();
        try (StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, storeLayout);){
            storeLocker.checkLock();
            Assert.fail();
        }
        catch (StoreLockException e) {
            String msg = String.format("Unable to obtain lock on store lock file: %s. Please ensure no other process is using this database, and that the directory is writable (required even for read-only access)", storeLayout.storeLockFile());
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)msg));
        }
    }

    @Test
    public void shouldNotObtainLockWhenStoreAlreadyInUse() throws Exception {
        DelegatingFileSystemAbstraction fileSystemAbstraction = new DelegatingFileSystemAbstraction(this.fileSystemRule.get()){

            public boolean fileExists(File file) {
                return false;
            }

            public StoreChannel open(File fileName, OpenMode openMode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, openMode)){

                    public FileLock tryLock() {
                        return null;
                    }
                };
            }
        };
        try (StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, this.target.storeLayout());){
            storeLocker.checkLock();
            Assert.fail();
        }
        catch (StoreLockException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Store and its lock file has been locked by another process"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustPreventMultipleInstancesFromStartingOnSameStore() {
        File storeDir = this.target.storeDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        try {
            new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
            Assert.fail((String)"Should not be able to start up another db in the same dir");
        }
        catch (Exception exception) {
        }
        finally {
            db.shutdown();
        }
    }

    private class CustomChannelFileSystemAbstraction
    extends DelegatingFileSystemAbstraction {
        private final StoreChannel channel;
        private int numberOfCallsToOpen;

        CustomChannelFileSystemAbstraction(DefaultFileSystemAbstraction delegate, StoreChannel channel) {
            super((FileSystemAbstraction)delegate);
            this.channel = channel;
        }

        public StoreChannel open(File fileName, OpenMode openMode) {
            ++this.numberOfCallsToOpen;
            return this.channel;
        }

        public int getNumberOfCallsToOpen() {
            return this.numberOfCallsToOpen;
        }
    }
}

