/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.StoreLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.locker.StoreLocker;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;
import org.neo4j.unsafe.batchinsert.internal.BatchInserterImpl;

public class BatchInserterImplTest {
    private static final String PAGE_CACHE_SIZE = "280K";
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final ExpectedException expected = ExpectedException.none();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.expected).around((TestRule)this.fileSystemRule);

    @Test
    public void testHonorsPassedInParams() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((File)this.testDirectory.databaseDir(), (FileSystemAbstraction)this.fileSystemRule.get(), this.inserterConfig());
        NeoStores neoStores = (NeoStores)ReflectionUtil.getPrivateField((Object)inserter, (String)"neoStores", NeoStores.class);
        PageCache pageCache = (PageCache)ReflectionUtil.getPrivateField((Object)neoStores, (String)"pageCache", PageCache.class);
        inserter.shutdown();
        long mappedMemoryTotalSize = MuninnPageCache.memoryRequiredForPages((long)pageCache.maxCachedPages());
        Assert.assertThat((String)"memory mapped config is active", (Object)mappedMemoryTotalSize, (Matcher)Matchers.is((Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(ByteUnit.kibiBytes((long)270L))), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(ByteUnit.kibiBytes((long)290L))))));
    }

    @Test
    public void testCreatesStoreLockFile() throws Exception {
        DatabaseLayout databaseLayout = this.testDirectory.databaseLayout();
        BatchInserter inserter = BatchInserters.inserter((File)databaseLayout.databaseDirectory(), (FileSystemAbstraction)this.fileSystemRule.get());
        Assert.assertThat((Object)databaseLayout.getStoreLayout().storeLockFile().exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        inserter.shutdown();
    }

    @Test
    public void testFailsOnExistingStoreLockFile() throws IOException {
        StoreLayout storeLayout = this.testDirectory.storeLayout();
        try (DefaultFileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();
             StoreLocker lock = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction, storeLayout);){
            lock.checkLock();
            this.expected.expect(StoreLockException.class);
            this.expected.expectMessage("Unable to obtain lock on store lock file");
            BatchInserters.inserter((File)storeLayout.databaseLayout("any").databaseDirectory(), (FileSystemAbstraction)fileSystemAbstraction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readOnlyInserterMustRefuseToCreateNode() throws IOException {
        BatchInserter inserter = this.readOnlyInserter();
        Label label = Label.label((String)"LABEL");
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        try {
            this.assertThrows(IllegalStateException.class, () -> inserter.createNode((Map)props, new Label[0]));
            this.assertThrows(IllegalStateException.class, () -> inserter.createNode(53L, (Map)props, new Label[0]));
            this.assertThrows(IllegalStateException.class, () -> inserter.createNode((Map)props, new Label[]{label}));
            this.assertThrows(IllegalStateException.class, () -> inserter.createNode(313L, (Map)props, new Label[]{label}));
            props.put("a", 1);
            this.assertThrows(IllegalStateException.class, () -> inserter.createNode((Map)props, new Label[0]));
            this.assertThrows(IllegalStateException.class, () -> inserter.createNode(711L, (Map)props, new Label[0]));
            this.assertThrows(IllegalStateException.class, () -> inserter.createNode((Map)props, new Label[]{label}));
            this.assertThrows(IllegalStateException.class, () -> inserter.createNode(1536L, (Map)props, new Label[]{label}));
        }
        finally {
            inserter.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readOnlyInserterMustRefuseToCreateRelationship() throws IOException {
        BatchInserter inserter = this.readOnlyInserter();
        RelationshipType type = RelationshipType.withName((String)"REL");
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        try {
            this.assertThrows(IllegalStateException.class, () -> inserter.createRelationship(1L, 2L, type, (Map)props));
            props.put("a", 1);
            this.assertThrows(IllegalStateException.class, () -> inserter.createRelationship(1L, 2L, type, (Map)props));
        }
        finally {
            inserter.shutdown();
        }
    }

    @Test
    public void readOnlyInserterMustRefuseToChangeNode() throws IOException {
        BatchInserter inserter = this.readOnlyInserter();
        try {
            this.assertThrows(IllegalStateException.class, () -> inserter.setNodeLabels(313L, new Label[]{Label.label((String)"LABEL")}));
            this.assertThrows(IllegalStateException.class, () -> inserter.setNodeProperty(313L, "prop", (Object)13));
            this.assertThrows(IllegalStateException.class, () -> inserter.setNodeProperties(313L, new HashMap()));
            this.assertThrows(IllegalStateException.class, () -> inserter.setNodeProperties(313L, Collections.singletonMap("prop", 13)));
            this.assertThrows(IllegalStateException.class, () -> inserter.removeNodeProperty(313L, "prop"));
        }
        finally {
            inserter.shutdown();
        }
    }

    @Test
    public void readOnlyInserterMustRefuseToChangeRelationship() throws IOException {
        BatchInserter inserter = this.readOnlyInserter();
        try {
            this.assertThrows(IllegalStateException.class, () -> inserter.setRelationshipProperty(313L, "prop", (Object)1));
            this.assertThrows(IllegalStateException.class, () -> inserter.setRelationshipProperties(313L, new HashMap()));
            this.assertThrows(IllegalStateException.class, () -> inserter.setRelationshipProperties(313L, Collections.singletonMap("prop", 1)));
            this.assertThrows(IllegalStateException.class, () -> inserter.removeRelationshipProperty(313L, "prop"));
        }
        finally {
            inserter.shutdown();
        }
    }

    @Test
    public void readOnlyInserterMustRefuseToChangeSchema() throws IOException {
        BatchInserter inserter = this.readOnlyInserter();
        Label label = Label.label((String)"Label");
        try {
            this.assertThrows(IllegalStateException.class, () -> inserter.createDeferredConstraint(label));
            this.assertThrows(IllegalStateException.class, () -> inserter.createDeferredSchemaIndex(label));
        }
        finally {
            inserter.shutdown();
        }
    }

    @Test
    public void readOnlyInserterMustNotRebuildLabelScanStoreOnShutDown() throws IOException {
        BatchInserterImpl inserter = (BatchInserterImpl)this.readOnlyInserter();
        Monitors monitors = inserter.getMonitors();
        final AtomicBoolean startedRebuilding = new AtomicBoolean();
        LabelScanStore.Monitor.Adaptor listener = new LabelScanStore.Monitor.Adaptor(){

            public void rebuilding() {
                startedRebuilding.set(true);
            }
        };
        monitors.addMonitorListener((Object)listener, new String[0]);
        inserter.shutdown();
        Assert.assertFalse((boolean)startedRebuilding.get());
    }

    @Test
    public void readOnlyInserterMustNotRebuildIndexesOnShutDown() throws IOException {
        DatabaseLayout layout = this.testDirectory.databaseLayout();
        File dir = layout.databaseDirectory();
        DefaultFileSystemAbstraction fsa = (DefaultFileSystemAbstraction)this.fileSystemRule.get();
        BatchInserter inserter = BatchInserters.inserter((File)dir, (FileSystemAbstraction)fsa, this.inserterConfig());
        Label label = Label.label((String)"LABEL");
        inserter.createDeferredSchemaIndex(label).on("prop").create();
        inserter.createNode(Collections.singletonMap("prop", 1), new Label[]{label});
        inserter.createNode(Collections.singletonMap("prop", 2), new Label[]{label});
        inserter.createNode(Collections.singletonMap("prop", 3), new Label[]{label});
        inserter.shutdown();
        BatchInserterImpl inserter2 = (BatchInserterImpl)this.readOnlyInserter();
        Monitors monitors = inserter2.getMonitors();
        final AtomicBoolean startedRebuilding = new AtomicBoolean();
        IndexingService.MonitorAdapter listener = new IndexingService.MonitorAdapter(){

            public void indexPopulationScanStarting() {
                startedRebuilding.set(true);
            }
        };
        monitors.addMonitorListener((Object)listener, new String[0]);
        inserter2.shutdown();
        Assert.assertFalse((boolean)startedRebuilding.get());
    }

    private BatchInserter readOnlyInserter() throws IOException {
        DatabaseLayout layout = this.testDirectory.databaseLayout();
        File dir = layout.databaseDirectory();
        DefaultFileSystemAbstraction fsa = (DefaultFileSystemAbstraction)this.fileSystemRule.get();
        Map<String, String> config = this.inserterConfig();
        config.put(GraphDatabaseSettings.read_only.name(), "true");
        return BatchInserters.inserter((File)dir, (FileSystemAbstraction)fsa, config);
    }

    private Map<String, String> inserterConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.pagecache_memory.name(), PAGE_CACHE_SIZE);
        return config;
    }

    private <E extends Exception> void assertThrows(Class<E> cls, ThrowingAction<E> action) {
        block2: {
            try {
                action.apply();
                Assert.fail((String)("Expected a " + cls + " exception to be thrown."));
            }
            catch (Exception e) {
                if (cls.isInstance(e)) break block2;
                AssertionError error = new AssertionError((Object)("Expected " + e + " to be an instance of " + cls));
                ((Throwable)((Object)error)).addSuppressed(e);
                throw error;
            }
        }
    }
}

