/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class FirstStartupIT {
    @Inject
    private TestDirectory testDir;

    FirstStartupIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeEmptyWhenFirstStarted() {
        File storeDir = this.testDir.absolutePath();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction transaction = db.beginTx();){
            Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)transaction.getAllNodes()));
            Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)transaction.getAllRelationships()));
            Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)transaction.getAllRelationshipTypes()));
            Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)transaction.getAllLabels()));
            Assertions.assertEquals((long)0L, (long)Iterables.count((Iterable)transaction.getAllPropertyKeys()));
        }
        finally {
            managementService.shutdown();
        }
    }
}

