/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

class BuiltInDbmsProceduresIT
extends KernelIntegrationTest {
    BuiltInDbmsProceduresIT() {
    }

    @Test
    void listConfig() throws Exception {
        List<AnyValue[]> config = this.callListConfig("");
        List names = config.stream().map(o -> ((TextValue)o[0]).stringValue()).collect(Collectors.toList());
        Assertions.assertTrue((names.size() > 10 ? 1 : 0) != 0);
        MatcherAssert.assertThat(names, (Matcher)Matchers.hasItem((Object)GraphDatabaseSettings.record_format.name()));
        Assertions.assertEquals((long)names.stream().filter(n -> n.startsWith("unsupported")).count(), (long)0L);
    }

    @Test
    void listConfigWithASpecificConfigName() throws Exception {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.strict_config_validation.name());
        Assertions.assertEquals((int)1, (int)config.size());
        Assertions.assertArrayEquals((Object[])new AnyValue[]{Values.stringValue((String)"dbms.config.strict_validation"), Values.stringValue((String)"A strict configuration validation will prevent the database from starting up if unknown configuration options are specified in the neo4j settings namespace (such as dbms., cypher., etc)."), Values.stringValue((String)"false"), Values.FALSE}, (Object[])config.get(0));
    }

    @Test
    void durationAlwaysListedWithUnit() throws Exception {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.transaction_timeout.name());
        Assertions.assertEquals((int)1, (int)config.size());
        Assertions.assertArrayEquals((Object[])new AnyValue[]{Values.stringValue((String)"dbms.transaction.timeout"), Values.stringValue((String)"The maximum time interval of a transaction within which it should be completed."), Values.stringValue((String)"0ns"), Values.TRUE}, (Object[])config.get(0));
    }

    @Test
    void listDynamicSetting() throws KernelException {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.check_point_iops_limit.name());
        Assertions.assertEquals((int)1, (int)config.size());
        Assertions.assertTrue((boolean)((BooleanValue)config.get(0)[3]).booleanValue());
    }

    @Test
    void listNotDynamicSetting() throws KernelException {
        List<AnyValue[]> config = this.callListConfig(GraphDatabaseSettings.data_directory.name());
        Assertions.assertEquals((int)1, (int)config.size());
        Assertions.assertFalse((boolean)((BooleanValue)config.get(0)[3]).booleanValue());
    }

    private List<AnyValue[]> callListConfig(String searchString) throws KernelException {
        QualifiedName procedureName = ProcedureSignature.procedureName((String[])new String[]{"dbms", "listConfig"});
        int procedureId = this.procs().procedureGet(procedureName).id();
        RawIterator callResult = this.dbmsOperations().procedureCallDbms(procedureId, (AnyValue[])ArrayUtils.toArray((Object[])new TextValue[]{Values.stringValue((String)searchString)}), this.transaction, this.dependencyResolver, SecurityContext.AUTH_DISABLED, ResourceTracker.EMPTY_RESOURCE_TRACKER, (ValueMapper)new DefaultValueMapper(this.transaction));
        return Iterators.asList((RawIterator)callResult);
    }
}

