/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.concurrent.Future;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.DbmsRule;
import org.neo4j.test.rule.ImpermanentDbmsRule;
import org.neo4j.test.rule.OtherThreadRule;

public class UniquenessConstraintValidationConcurrencyIT {
    @Rule
    public final DbmsRule database = new ImpermanentDbmsRule();
    @Rule
    public final OtherThreadRule<Void> otherThread = new OtherThreadRule();

    @Test
    public void shouldAllowConcurrentCreationOfNonConflictingData() throws Exception {
        this.database.executeAndCommit(this.createUniquenessConstraint("Label1", "key1"));
        Future created = (Future)this.database.executeAndCommit(tx -> {
            tx.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            return this.otherThread.execute(this.createNode((Transaction)tx, "Label1", "key1", "value2"));
        });
        Assert.assertTrue((String)"Node creation should succeed", (boolean)((Boolean)created.get()));
    }

    @Test
    public void shouldPreventConcurrentCreationOfConflictingData() throws Exception {
        this.database.executeAndCommit(this.createUniquenessConstraint("Label1", "key1"));
        Future created = (Future)this.database.executeAndCommit(tx -> {
            tx.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            try {
                Future future = this.otherThread.execute(this.createNode((Transaction)tx, "Label1", "key1", "value1"));
                return future;
            }
            finally {
                Assert.assertThat(this.otherThread, (Matcher)OtherThreadRule.isWaiting());
            }
        });
        Assert.assertFalse((String)"node creation should fail", (boolean)((Boolean)created.get()));
    }

    @Test
    public void shouldAllowOtherTransactionToCompleteIfFirstTransactionRollsBack() throws Exception {
        this.database.executeAndCommit(this.createUniquenessConstraint("Label1", "key1"));
        Future created = (Future)this.database.executeAndRollback(tx -> {
            tx.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            try {
                Future future = this.otherThread.execute(this.createNode((Transaction)tx, "Label1", "key1", "value1"));
                return future;
            }
            finally {
                Assert.assertThat(this.otherThread, (Matcher)OtherThreadRule.isWaiting());
            }
        });
        Assert.assertTrue((String)"Node creation should succeed", (boolean)((Boolean)created.get()));
    }

    private Function<Transaction, Void> createUniquenessConstraint(String label, String propertyKey) {
        return transaction -> {
            transaction.schema().constraintFor(Label.label((String)label)).assertPropertyIsUnique(propertyKey).create();
            return null;
        };
    }

    public OtherThreadExecutor.WorkerCommand<Void, Boolean> createNode(Transaction transaction, String label, String propertyKey, Object propertyValue) {
        return nothing -> {
            Boolean bl;
            block8: {
                Transaction tx = this.database.beginTx();
                try {
                    tx.createNode(new Label[]{Label.label((String)label)}).setProperty(propertyKey, propertyValue);
                    tx.commit();
                    bl = true;
                    if (tx == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConstraintViolationException e) {
                        return false;
                    }
                }
                tx.close();
            }
            return bl;
        };
    }
}

